package zio.aws.athena.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.{
  MaxDatabasesCount,
  Token,
  CatalogNameString
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListDatabasesRequest(
    catalogName: CatalogNameString,
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[MaxDatabasesCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListDatabasesRequest = {
    import ListDatabasesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListDatabasesRequest
      .builder()
      .catalogName(CatalogNameString.unwrap(catalogName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxDatabasesCount.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListDatabasesRequest.ReadOnly =
    zio.aws.athena.model.ListDatabasesRequest.wrap(buildAwsValue())
}
object ListDatabasesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListDatabasesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListDatabasesRequest =
      zio.aws.athena.model.ListDatabasesRequest(
        catalogName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def catalogName: CatalogNameString
    def nextToken: Optional[Token]
    def maxResults: Optional[MaxDatabasesCount]
    def getCatalogName: ZIO[Any, Nothing, CatalogNameString] =
      ZIO.succeed(catalogName)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxDatabasesCount] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListDatabasesRequest
  ) extends zio.aws.athena.model.ListDatabasesRequest.ReadOnly {
    override val catalogName: CatalogNameString =
      zio.aws.athena.model.primitives.CatalogNameString(impl.catalogName())
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
    override val maxResults: Optional[MaxDatabasesCount] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.athena.model.primitives.MaxDatabasesCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListDatabasesRequest
  ): zio.aws.athena.model.ListDatabasesRequest.ReadOnly = new Wrapper(impl)
}
