package zio.aws.athena.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.{
  SessionManagerToken,
  MaxCalculationsCount,
  SessionId
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListCalculationExecutionsRequest(
    sessionId: SessionId,
    stateFilter: Optional[zio.aws.athena.model.CalculationExecutionState] =
      Optional.Absent,
    maxResults: Optional[MaxCalculationsCount] = Optional.Absent,
    nextToken: Optional[SessionManagerToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListCalculationExecutionsRequest = {
    import ListCalculationExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListCalculationExecutionsRequest
      .builder()
      .sessionId(SessionId.unwrap(sessionId): java.lang.String)
      .optionallyWith(stateFilter.map(value => value.unwrap))(_.stateFilter)
      .optionallyWith(
        maxResults.map(value => MaxCalculationsCount.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value =>
          SessionManagerToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.ListCalculationExecutionsRequest.ReadOnly =
    zio.aws.athena.model.ListCalculationExecutionsRequest.wrap(buildAwsValue())
}
object ListCalculationExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListCalculationExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListCalculationExecutionsRequest =
      zio.aws.athena.model.ListCalculationExecutionsRequest(
        sessionId,
        stateFilter.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def sessionId: SessionId
    def stateFilter: Optional[zio.aws.athena.model.CalculationExecutionState]
    def maxResults: Optional[MaxCalculationsCount]
    def nextToken: Optional[SessionManagerToken]
    def getSessionId: ZIO[Any, Nothing, SessionId] = ZIO.succeed(sessionId)
    def getStateFilter
        : ZIO[Any, AwsError, zio.aws.athena.model.CalculationExecutionState] =
      AwsError.unwrapOptionField("stateFilter", stateFilter)
    def getMaxResults: ZIO[Any, AwsError, MaxCalculationsCount] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, SessionManagerToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListCalculationExecutionsRequest
  ) extends zio.aws.athena.model.ListCalculationExecutionsRequest.ReadOnly {
    override val sessionId: SessionId =
      zio.aws.athena.model.primitives.SessionId(impl.sessionId())
    override val stateFilter
        : Optional[zio.aws.athena.model.CalculationExecutionState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateFilter())
        .map(value =>
          zio.aws.athena.model.CalculationExecutionState.wrap(value)
        )
    override val maxResults: Optional[MaxCalculationsCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.athena.model.primitives.MaxCalculationsCount(value)
        )
    override val nextToken: Optional[SessionManagerToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.athena.model.primitives.SessionManagerToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListCalculationExecutionsRequest
  ): zio.aws.athena.model.ListCalculationExecutionsRequest.ReadOnly =
    new Wrapper(impl)
}
