package zio.aws.athena.model
import zio.aws.athena.model.primitives.SessionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetSessionRequest(sessionId: SessionId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetSessionRequest = {
    import GetSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetSessionRequest
      .builder()
      .sessionId(SessionId.unwrap(sessionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.GetSessionRequest.ReadOnly =
    zio.aws.athena.model.GetSessionRequest.wrap(buildAwsValue())
}
object GetSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetSessionRequest =
      zio.aws.athena.model.GetSessionRequest(sessionId)
    def sessionId: SessionId
    def getSessionId: ZIO[Any, Nothing, SessionId] = ZIO.succeed(sessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetSessionRequest
  ) extends zio.aws.athena.model.GetSessionRequest.ReadOnly {
    override val sessionId: SessionId =
      zio.aws.athena.model.primitives.SessionId(impl.sessionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetSessionRequest
  ): zio.aws.athena.model.GetSessionRequest.ReadOnly = new Wrapper(impl)
}
