package zio.aws.athena.model
import zio.aws.athena.model.primitives.{
  S3Uri,
  DescriptionString,
  SessionId,
  CalculationExecutionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetCalculationExecutionResponse(
    calculationExecutionId: Optional[CalculationExecutionId] = Optional.Absent,
    sessionId: Optional[SessionId] = Optional.Absent,
    description: Optional[DescriptionString] = Optional.Absent,
    workingDirectory: Optional[S3Uri] = Optional.Absent,
    status: Optional[zio.aws.athena.model.CalculationStatus] = Optional.Absent,
    statistics: Optional[zio.aws.athena.model.CalculationStatistics] =
      Optional.Absent,
    result: Optional[zio.aws.athena.model.CalculationResult] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetCalculationExecutionResponse = {
    import GetCalculationExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetCalculationExecutionResponse
      .builder()
      .optionallyWith(
        calculationExecutionId.map(value =>
          CalculationExecutionId.unwrap(value): java.lang.String
        )
      )(_.calculationExecutionId)
      .optionallyWith(
        sessionId.map(value => SessionId.unwrap(value): java.lang.String)
      )(_.sessionId)
      .optionallyWith(
        description.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        workingDirectory.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.workingDirectory)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(statistics.map(value => value.buildAwsValue()))(
        _.statistics
      )
      .optionallyWith(result.map(value => value.buildAwsValue()))(_.result)
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.GetCalculationExecutionResponse.ReadOnly =
    zio.aws.athena.model.GetCalculationExecutionResponse.wrap(buildAwsValue())
}
object GetCalculationExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetCalculationExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetCalculationExecutionResponse =
      zio.aws.athena.model.GetCalculationExecutionResponse(
        calculationExecutionId.map(value => value),
        sessionId.map(value => value),
        description.map(value => value),
        workingDirectory.map(value => value),
        status.map(value => value.asEditable),
        statistics.map(value => value.asEditable),
        result.map(value => value.asEditable)
      )
    def calculationExecutionId: Optional[CalculationExecutionId]
    def sessionId: Optional[SessionId]
    def description: Optional[DescriptionString]
    def workingDirectory: Optional[S3Uri]
    def status: Optional[zio.aws.athena.model.CalculationStatus.ReadOnly]
    def statistics
        : Optional[zio.aws.athena.model.CalculationStatistics.ReadOnly]
    def result: Optional[zio.aws.athena.model.CalculationResult.ReadOnly]
    def getCalculationExecutionId: ZIO[Any, AwsError, CalculationExecutionId] =
      AwsError.unwrapOptionField(
        "calculationExecutionId",
        calculationExecutionId
      )
    def getSessionId: ZIO[Any, AwsError, SessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getWorkingDirectory: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("workingDirectory", workingDirectory)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.athena.model.CalculationStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
    def getStatistics: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.CalculationStatistics.ReadOnly
    ] = AwsError.unwrapOptionField("statistics", statistics)
    def getResult
        : ZIO[Any, AwsError, zio.aws.athena.model.CalculationResult.ReadOnly] =
      AwsError.unwrapOptionField("result", result)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetCalculationExecutionResponse
  ) extends zio.aws.athena.model.GetCalculationExecutionResponse.ReadOnly {
    override val calculationExecutionId: Optional[CalculationExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.calculationExecutionId())
        .map(value =>
          zio.aws.athena.model.primitives.CalculationExecutionId(value)
        )
    override val sessionId: Optional[SessionId] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value => zio.aws.athena.model.primitives.SessionId(value))
    override val description: Optional[DescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.athena.model.primitives.DescriptionString(value))
    override val workingDirectory: Optional[S3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.workingDirectory())
      .map(value => zio.aws.athena.model.primitives.S3Uri(value))
    override val status
        : Optional[zio.aws.athena.model.CalculationStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.athena.model.CalculationStatus.wrap(value))
    override val statistics
        : Optional[zio.aws.athena.model.CalculationStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistics())
        .map(value => zio.aws.athena.model.CalculationStatistics.wrap(value))
    override val result
        : Optional[zio.aws.athena.model.CalculationResult.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.result())
        .map(value => zio.aws.athena.model.CalculationResult.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetCalculationExecutionResponse
  ): zio.aws.athena.model.GetCalculationExecutionResponse.ReadOnly =
    new Wrapper(impl)
}
