package zio.aws.athena.model
import zio.aws.athena.model.primitives.ExecutorId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ExecutorsSummary(
    executorId: ExecutorId,
    executorType: Optional[zio.aws.athena.model.ExecutorType] = Optional.Absent,
    startDateTime: Optional[Long] = Optional.Absent,
    terminationDateTime: Optional[Long] = Optional.Absent,
    executorState: Optional[zio.aws.athena.model.ExecutorState] =
      Optional.Absent,
    executorSize: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ExecutorsSummary = {
    import ExecutorsSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ExecutorsSummary
      .builder()
      .executorId(ExecutorId.unwrap(executorId): java.lang.String)
      .optionallyWith(executorType.map(value => value.unwrap))(_.executorType)
      .optionallyWith(startDateTime.map(value => value: java.lang.Long))(
        _.startDateTime
      )
      .optionallyWith(terminationDateTime.map(value => value: java.lang.Long))(
        _.terminationDateTime
      )
      .optionallyWith(executorState.map(value => value.unwrap))(_.executorState)
      .optionallyWith(executorSize.map(value => value: java.lang.Long))(
        _.executorSize
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ExecutorsSummary.ReadOnly =
    zio.aws.athena.model.ExecutorsSummary.wrap(buildAwsValue())
}
object ExecutorsSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ExecutorsSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ExecutorsSummary =
      zio.aws.athena.model.ExecutorsSummary(
        executorId,
        executorType.map(value => value),
        startDateTime.map(value => value),
        terminationDateTime.map(value => value),
        executorState.map(value => value),
        executorSize.map(value => value)
      )
    def executorId: ExecutorId
    def executorType: Optional[zio.aws.athena.model.ExecutorType]
    def startDateTime: Optional[Long]
    def terminationDateTime: Optional[Long]
    def executorState: Optional[zio.aws.athena.model.ExecutorState]
    def executorSize: Optional[Long]
    def getExecutorId: ZIO[Any, Nothing, ExecutorId] = ZIO.succeed(executorId)
    def getExecutorType: ZIO[Any, AwsError, zio.aws.athena.model.ExecutorType] =
      AwsError.unwrapOptionField("executorType", executorType)
    def getStartDateTime: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("startDateTime", startDateTime)
    def getTerminationDateTime: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("terminationDateTime", terminationDateTime)
    def getExecutorState
        : ZIO[Any, AwsError, zio.aws.athena.model.ExecutorState] =
      AwsError.unwrapOptionField("executorState", executorState)
    def getExecutorSize: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("executorSize", executorSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ExecutorsSummary
  ) extends zio.aws.athena.model.ExecutorsSummary.ReadOnly {
    override val executorId: ExecutorId =
      zio.aws.athena.model.primitives.ExecutorId(impl.executorId())
    override val executorType: Optional[zio.aws.athena.model.ExecutorType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executorType())
        .map(value => zio.aws.athena.model.ExecutorType.wrap(value))
    override val startDateTime: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.startDateTime())
      .map(value => value: Long)
    override val terminationDateTime: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.terminationDateTime())
      .map(value => value: Long)
    override val executorState: Optional[zio.aws.athena.model.ExecutorState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executorState())
        .map(value => zio.aws.athena.model.ExecutorState.wrap(value))
    override val executorSize: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.executorSize())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ExecutorsSummary
  ): zio.aws.athena.model.ExecutorsSummary.ReadOnly = new Wrapper(impl)
}
