package zio.aws.athena
import zio.aws.athena.model.StartCalculationExecutionResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.athena.model.{
  CreateWorkGroupRequest,
  ListCalculationExecutionsRequest,
  UpdateNotebookMetadataRequest,
  ExportNotebookRequest,
  ListNotebookMetadataRequest,
  GetDataCatalogRequest,
  GetWorkGroupRequest,
  ListWorkGroupsRequest,
  GetCalculationExecutionCodeRequest,
  GetNamedQueryRequest,
  DeleteDataCatalogRequest,
  ListTagsForResourceRequest,
  DeleteNotebookRequest,
  GetDatabaseRequest,
  BatchGetPreparedStatementRequest,
  CreatePreparedStatementRequest,
  DeleteWorkGroupRequest,
  DeletePreparedStatementRequest,
  ListDatabasesRequest,
  ListDataCatalogsRequest,
  GetPreparedStatementRequest,
  ListNotebookSessionsRequest,
  TerminateSessionRequest,
  ListQueryExecutionsRequest,
  ListPreparedStatementsRequest,
  GetQueryRuntimeStatisticsRequest,
  UpdateWorkGroupRequest,
  BatchGetQueryExecutionRequest,
  StartSessionRequest,
  GetCalculationExecutionStatusRequest,
  ListSessionsRequest,
  StartQueryExecutionRequest,
  CreatePresignedNotebookUrlRequest,
  ListTableMetadataRequest,
  StopCalculationExecutionRequest,
  CreateNamedQueryRequest,
  GetSessionRequest,
  ListEngineVersionsRequest,
  CreateDataCatalogRequest,
  UntagResourceRequest,
  GetSessionStatusRequest,
  GetQueryResultsRequest,
  GetTableMetadataRequest,
  ListExecutorsRequest,
  UpdateDataCatalogRequest,
  DeleteNamedQueryRequest,
  ImportNotebookRequest,
  UpdateNamedQueryRequest,
  UpdatePreparedStatementRequest,
  UpdateNotebookRequest,
  ListNamedQueriesRequest,
  GetCalculationExecutionRequest,
  ListApplicationDpuSizesRequest,
  GetQueryExecutionRequest,
  StopQueryExecutionRequest,
  StartCalculationExecutionRequest,
  BatchGetNamedQueryRequest,
  CreateNotebookRequest,
  TagResourceRequest,
  GetNotebookMetadataRequest
}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.athena.AthenaAsyncClient
import zio.aws.athena.model.primitives.{NamedQueryId, QueryExecutionId}
import zio.stream.ZStream
object AthenaMock extends Mock[Athena] {
  object ListDatabases
      extends Stream[
        ListDatabasesRequest,
        AwsError,
        zio.aws.athena.model.Database.ReadOnly
      ]
  object ListDatabasesPaginated
      extends Effect[
        ListDatabasesRequest,
        AwsError,
        zio.aws.athena.model.ListDatabasesResponse.ReadOnly
      ]
  object UpdateDataCatalog
      extends Effect[
        UpdateDataCatalogRequest,
        AwsError,
        zio.aws.athena.model.UpdateDataCatalogResponse.ReadOnly
      ]
  object ListNotebookSessions
      extends Stream[
        ListNotebookSessionsRequest,
        AwsError,
        zio.aws.athena.model.NotebookSessionSummary.ReadOnly
      ]
  object ListNotebookSessionsPaginated
      extends Effect[
        ListNotebookSessionsRequest,
        AwsError,
        zio.aws.athena.model.ListNotebookSessionsResponse.ReadOnly
      ]
  object UpdateWorkGroup
      extends Effect[
        UpdateWorkGroupRequest,
        AwsError,
        zio.aws.athena.model.UpdateWorkGroupResponse.ReadOnly
      ]
  object StopCalculationExecution
      extends Effect[
        StopCalculationExecutionRequest,
        AwsError,
        zio.aws.athena.model.StopCalculationExecutionResponse.ReadOnly
      ]
  object GetPreparedStatement
      extends Effect[
        GetPreparedStatementRequest,
        AwsError,
        zio.aws.athena.model.GetPreparedStatementResponse.ReadOnly
      ]
  object ListQueryExecutions
      extends Stream[ListQueryExecutionsRequest, AwsError, QueryExecutionId]
  object ListQueryExecutionsPaginated
      extends Effect[
        ListQueryExecutionsRequest,
        AwsError,
        zio.aws.athena.model.ListQueryExecutionsResponse.ReadOnly
      ]
  object ListDataCatalogs
      extends Stream[
        ListDataCatalogsRequest,
        AwsError,
        zio.aws.athena.model.DataCatalogSummary.ReadOnly
      ]
  object ListDataCatalogsPaginated
      extends Effect[
        ListDataCatalogsRequest,
        AwsError,
        zio.aws.athena.model.ListDataCatalogsResponse.ReadOnly
      ]
  object GetNamedQuery
      extends Effect[
        GetNamedQueryRequest,
        AwsError,
        zio.aws.athena.model.GetNamedQueryResponse.ReadOnly
      ]
  object GetNotebookMetadata
      extends Effect[
        GetNotebookMetadataRequest,
        AwsError,
        zio.aws.athena.model.GetNotebookMetadataResponse.ReadOnly
      ]
  object UpdateNamedQuery
      extends Effect[
        UpdateNamedQueryRequest,
        AwsError,
        zio.aws.athena.model.UpdateNamedQueryResponse.ReadOnly
      ]
  object ListExecutors
      extends Effect[ListExecutorsRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.athena.model.ListExecutorsResponse.ReadOnly,
        zio.aws.athena.model.ExecutorsSummary.ReadOnly
      ]]
  object ListExecutorsPaginated
      extends Effect[
        ListExecutorsRequest,
        AwsError,
        zio.aws.athena.model.ListExecutorsResponse.ReadOnly
      ]
  object DeletePreparedStatement
      extends Effect[
        DeletePreparedStatementRequest,
        AwsError,
        zio.aws.athena.model.DeletePreparedStatementResponse.ReadOnly
      ]
  object ListEngineVersions
      extends Stream[
        ListEngineVersionsRequest,
        AwsError,
        zio.aws.athena.model.EngineVersion.ReadOnly
      ]
  object ListEngineVersionsPaginated
      extends Effect[
        ListEngineVersionsRequest,
        AwsError,
        zio.aws.athena.model.ListEngineVersionsResponse.ReadOnly
      ]
  object GetQueryRuntimeStatistics
      extends Effect[
        GetQueryRuntimeStatisticsRequest,
        AwsError,
        zio.aws.athena.model.GetQueryRuntimeStatisticsResponse.ReadOnly
      ]
  object DeleteNamedQuery
      extends Effect[
        DeleteNamedQueryRequest,
        AwsError,
        zio.aws.athena.model.DeleteNamedQueryResponse.ReadOnly
      ]
  object UpdateNotebookMetadata
      extends Effect[
        UpdateNotebookMetadataRequest,
        AwsError,
        zio.aws.athena.model.UpdateNotebookMetadataResponse.ReadOnly
      ]
  object GetTableMetadata
      extends Effect[
        GetTableMetadataRequest,
        AwsError,
        zio.aws.athena.model.GetTableMetadataResponse.ReadOnly
      ]
  object BatchGetNamedQuery
      extends Effect[
        BatchGetNamedQueryRequest,
        AwsError,
        zio.aws.athena.model.BatchGetNamedQueryResponse.ReadOnly
      ]
  object ListApplicationDPUSizes
      extends Stream[
        ListApplicationDpuSizesRequest,
        AwsError,
        zio.aws.athena.model.ApplicationDPUSizes.ReadOnly
      ]
  object ListApplicationDPUSizesPaginated
      extends Effect[
        ListApplicationDpuSizesRequest,
        AwsError,
        zio.aws.athena.model.ListApplicationDpuSizesResponse.ReadOnly
      ]
  object CreateNamedQuery
      extends Effect[
        CreateNamedQueryRequest,
        AwsError,
        zio.aws.athena.model.CreateNamedQueryResponse.ReadOnly
      ]
  object TerminateSession
      extends Effect[
        TerminateSessionRequest,
        AwsError,
        zio.aws.athena.model.TerminateSessionResponse.ReadOnly
      ]
  object GetDataCatalog
      extends Effect[
        GetDataCatalogRequest,
        AwsError,
        zio.aws.athena.model.GetDataCatalogResponse.ReadOnly
      ]
  object DeleteNotebook
      extends Effect[
        DeleteNotebookRequest,
        AwsError,
        zio.aws.athena.model.DeleteNotebookResponse.ReadOnly
      ]
  object CreateNotebook
      extends Effect[
        CreateNotebookRequest,
        AwsError,
        zio.aws.athena.model.CreateNotebookResponse.ReadOnly
      ]
  object ListCalculationExecutions
      extends Stream[
        ListCalculationExecutionsRequest,
        AwsError,
        zio.aws.athena.model.CalculationSummary.ReadOnly
      ]
  object ListCalculationExecutionsPaginated
      extends Effect[
        ListCalculationExecutionsRequest,
        AwsError,
        zio.aws.athena.model.ListCalculationExecutionsResponse.ReadOnly
      ]
  object ListWorkGroups
      extends Stream[
        ListWorkGroupsRequest,
        AwsError,
        zio.aws.athena.model.WorkGroupSummary.ReadOnly
      ]
  object ListWorkGroupsPaginated
      extends Effect[
        ListWorkGroupsRequest,
        AwsError,
        zio.aws.athena.model.ListWorkGroupsResponse.ReadOnly
      ]
  object ListPreparedStatements
      extends Stream[
        ListPreparedStatementsRequest,
        AwsError,
        zio.aws.athena.model.PreparedStatementSummary.ReadOnly
      ]
  object ListPreparedStatementsPaginated
      extends Effect[
        ListPreparedStatementsRequest,
        AwsError,
        zio.aws.athena.model.ListPreparedStatementsResponse.ReadOnly
      ]
  object CreatePreparedStatement
      extends Effect[
        CreatePreparedStatementRequest,
        AwsError,
        zio.aws.athena.model.CreatePreparedStatementResponse.ReadOnly
      ]
  object DeleteDataCatalog
      extends Effect[
        DeleteDataCatalogRequest,
        AwsError,
        zio.aws.athena.model.DeleteDataCatalogResponse.ReadOnly
      ]
  object UpdateNotebook
      extends Effect[
        UpdateNotebookRequest,
        AwsError,
        zio.aws.athena.model.UpdateNotebookResponse.ReadOnly
      ]
  object ListNotebookMetadata
      extends Stream[
        ListNotebookMetadataRequest,
        AwsError,
        zio.aws.athena.model.NotebookMetadata.ReadOnly
      ]
  object ListNotebookMetadataPaginated
      extends Effect[
        ListNotebookMetadataRequest,
        AwsError,
        zio.aws.athena.model.ListNotebookMetadataResponse.ReadOnly
      ]
  object CreatePresignedNotebookUrl
      extends Effect[
        CreatePresignedNotebookUrlRequest,
        AwsError,
        zio.aws.athena.model.CreatePresignedNotebookUrlResponse.ReadOnly
      ]
  object GetQueryExecution
      extends Effect[
        GetQueryExecutionRequest,
        AwsError,
        zio.aws.athena.model.GetQueryExecutionResponse.ReadOnly
      ]
  object UpdatePreparedStatement
      extends Effect[
        UpdatePreparedStatementRequest,
        AwsError,
        zio.aws.athena.model.UpdatePreparedStatementResponse.ReadOnly
      ]
  object CreateDataCatalog
      extends Effect[
        CreateDataCatalogRequest,
        AwsError,
        zio.aws.athena.model.CreateDataCatalogResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.athena.model.UntagResourceResponse.ReadOnly
      ]
  object ExportNotebook
      extends Effect[
        ExportNotebookRequest,
        AwsError,
        zio.aws.athena.model.ExportNotebookResponse.ReadOnly
      ]
  object GetSessionStatus
      extends Effect[
        GetSessionStatusRequest,
        AwsError,
        zio.aws.athena.model.GetSessionStatusResponse.ReadOnly
      ]
  object ListTableMetadata
      extends Stream[
        ListTableMetadataRequest,
        AwsError,
        zio.aws.athena.model.TableMetadata.ReadOnly
      ]
  object ListTableMetadataPaginated
      extends Effect[
        ListTableMetadataRequest,
        AwsError,
        zio.aws.athena.model.ListTableMetadataResponse.ReadOnly
      ]
  object StartCalculationExecution
      extends Effect[StartCalculationExecutionRequest, AwsError, ReadOnly]
  object ListTagsForResource
      extends Stream[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.athena.model.Tag.ReadOnly
      ]
  object ListTagsForResourcePaginated
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.athena.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.athena.model.TagResourceResponse.ReadOnly
      ]
  object StartSession
      extends Effect[
        StartSessionRequest,
        AwsError,
        zio.aws.athena.model.StartSessionResponse.ReadOnly
      ]
  object ListSessions
      extends Stream[
        ListSessionsRequest,
        AwsError,
        zio.aws.athena.model.SessionSummary.ReadOnly
      ]
  object ListSessionsPaginated
      extends Effect[
        ListSessionsRequest,
        AwsError,
        zio.aws.athena.model.ListSessionsResponse.ReadOnly
      ]
  object GetCalculationExecutionCode
      extends Effect[
        GetCalculationExecutionCodeRequest,
        AwsError,
        zio.aws.athena.model.GetCalculationExecutionCodeResponse.ReadOnly
      ]
  object ListNamedQueries
      extends Stream[ListNamedQueriesRequest, AwsError, NamedQueryId]
  object ListNamedQueriesPaginated
      extends Effect[
        ListNamedQueriesRequest,
        AwsError,
        zio.aws.athena.model.ListNamedQueriesResponse.ReadOnly
      ]
  object DeleteWorkGroup
      extends Effect[
        DeleteWorkGroupRequest,
        AwsError,
        zio.aws.athena.model.DeleteWorkGroupResponse.ReadOnly
      ]
  object GetSession
      extends Effect[
        GetSessionRequest,
        AwsError,
        zio.aws.athena.model.GetSessionResponse.ReadOnly
      ]
  object ImportNotebook
      extends Effect[
        ImportNotebookRequest,
        AwsError,
        zio.aws.athena.model.ImportNotebookResponse.ReadOnly
      ]
  object GetDatabase
      extends Effect[
        GetDatabaseRequest,
        AwsError,
        zio.aws.athena.model.GetDatabaseResponse.ReadOnly
      ]
  object GetCalculationExecutionStatus
      extends Effect[
        GetCalculationExecutionStatusRequest,
        AwsError,
        zio.aws.athena.model.GetCalculationExecutionStatusResponse.ReadOnly
      ]
  object BatchGetPreparedStatement
      extends Effect[
        BatchGetPreparedStatementRequest,
        AwsError,
        zio.aws.athena.model.BatchGetPreparedStatementResponse.ReadOnly
      ]
  object CreateWorkGroup
      extends Effect[
        CreateWorkGroupRequest,
        AwsError,
        zio.aws.athena.model.CreateWorkGroupResponse.ReadOnly
      ]
  object GetWorkGroup
      extends Effect[
        GetWorkGroupRequest,
        AwsError,
        zio.aws.athena.model.GetWorkGroupResponse.ReadOnly
      ]
  object BatchGetQueryExecution
      extends Effect[
        BatchGetQueryExecutionRequest,
        AwsError,
        zio.aws.athena.model.BatchGetQueryExecutionResponse.ReadOnly
      ]
  object GetCalculationExecution
      extends Effect[
        GetCalculationExecutionRequest,
        AwsError,
        zio.aws.athena.model.GetCalculationExecutionResponse.ReadOnly
      ]
  object StartQueryExecution
      extends Effect[
        StartQueryExecutionRequest,
        AwsError,
        zio.aws.athena.model.StartQueryExecutionResponse.ReadOnly
      ]
  object GetQueryResults
      extends Effect[GetQueryResultsRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.athena.model.ResultSetMetadata.ReadOnly,
        zio.aws.athena.model.Row.ReadOnly
      ]]
  object GetQueryResultsPaginated
      extends Effect[
        GetQueryResultsRequest,
        AwsError,
        zio.aws.athena.model.GetQueryResultsResponse.ReadOnly
      ]
  object StopQueryExecution
      extends Effect[
        StopQueryExecutionRequest,
        AwsError,
        zio.aws.athena.model.StopQueryExecutionResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Athena] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Athena] { rts =>
        ZIO.succeed {
          new Athena {
            val api: AthenaAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Athena = this
            def listDatabases(
                request: ListDatabasesRequest
            ): ZStream[Any, AwsError, zio.aws.athena.model.Database.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListDatabases, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listDatabasesPaginated(request: ListDatabasesRequest): IO[
              AwsError,
              zio.aws.athena.model.ListDatabasesResponse.ReadOnly
            ] = proxy(ListDatabasesPaginated, request)
            def updateDataCatalog(request: UpdateDataCatalogRequest): IO[
              AwsError,
              zio.aws.athena.model.UpdateDataCatalogResponse.ReadOnly
            ] = proxy(UpdateDataCatalog, request)
            def listNotebookSessions(
                request: ListNotebookSessionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.athena.model.NotebookSessionSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListNotebookSessions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listNotebookSessionsPaginated(
                request: ListNotebookSessionsRequest
            ): IO[
              AwsError,
              zio.aws.athena.model.ListNotebookSessionsResponse.ReadOnly
            ] = proxy(ListNotebookSessionsPaginated, request)
            def updateWorkGroup(request: UpdateWorkGroupRequest): IO[
              AwsError,
              zio.aws.athena.model.UpdateWorkGroupResponse.ReadOnly
            ] = proxy(UpdateWorkGroup, request)
            def stopCalculationExecution(
                request: StopCalculationExecutionRequest
            ): IO[
              AwsError,
              zio.aws.athena.model.StopCalculationExecutionResponse.ReadOnly
            ] = proxy(StopCalculationExecution, request)
            def getPreparedStatement(request: GetPreparedStatementRequest): IO[
              AwsError,
              zio.aws.athena.model.GetPreparedStatementResponse.ReadOnly
            ] = proxy(GetPreparedStatement, request)
            def listQueryExecutions(
                request: ListQueryExecutionsRequest
            ): ZStream[Any, AwsError, QueryExecutionId] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListQueryExecutions, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listQueryExecutionsPaginated(
                request: ListQueryExecutionsRequest
            ): IO[
              AwsError,
              zio.aws.athena.model.ListQueryExecutionsResponse.ReadOnly
            ] = proxy(ListQueryExecutionsPaginated, request)
            def listDataCatalogs(request: ListDataCatalogsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.athena.model.DataCatalogSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDataCatalogs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDataCatalogsPaginated(request: ListDataCatalogsRequest): IO[
              AwsError,
              zio.aws.athena.model.ListDataCatalogsResponse.ReadOnly
            ] = proxy(ListDataCatalogsPaginated, request)
            def getNamedQuery(request: GetNamedQueryRequest): IO[
              AwsError,
              zio.aws.athena.model.GetNamedQueryResponse.ReadOnly
            ] = proxy(GetNamedQuery, request)
            def getNotebookMetadata(request: GetNotebookMetadataRequest): IO[
              AwsError,
              zio.aws.athena.model.GetNotebookMetadataResponse.ReadOnly
            ] = proxy(GetNotebookMetadata, request)
            def updateNamedQuery(request: UpdateNamedQueryRequest): IO[
              AwsError,
              zio.aws.athena.model.UpdateNamedQueryResponse.ReadOnly
            ] = proxy(UpdateNamedQuery, request)
            def listExecutors(
                request: ListExecutorsRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.athena.model.ListExecutorsResponse.ReadOnly,
              zio.aws.athena.model.ExecutorsSummary.ReadOnly
            ]] = proxy(ListExecutors, request)
            def listExecutorsPaginated(request: ListExecutorsRequest): IO[
              AwsError,
              zio.aws.athena.model.ListExecutorsResponse.ReadOnly
            ] = proxy(ListExecutorsPaginated, request)
            def deletePreparedStatement(
                request: DeletePreparedStatementRequest
            ): IO[
              AwsError,
              zio.aws.athena.model.DeletePreparedStatementResponse.ReadOnly
            ] = proxy(DeletePreparedStatement, request)
            def listEngineVersions(request: ListEngineVersionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.athena.model.EngineVersion.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEngineVersions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEngineVersionsPaginated(
                request: ListEngineVersionsRequest
            ): IO[
              AwsError,
              zio.aws.athena.model.ListEngineVersionsResponse.ReadOnly
            ] = proxy(ListEngineVersionsPaginated, request)
            def getQueryRuntimeStatistics(
                request: GetQueryRuntimeStatisticsRequest
            ): IO[
              AwsError,
              zio.aws.athena.model.GetQueryRuntimeStatisticsResponse.ReadOnly
            ] = proxy(GetQueryRuntimeStatistics, request)
            def deleteNamedQuery(request: DeleteNamedQueryRequest): IO[
              AwsError,
              zio.aws.athena.model.DeleteNamedQueryResponse.ReadOnly
            ] = proxy(DeleteNamedQuery, request)
            def updateNotebookMetadata(
                request: UpdateNotebookMetadataRequest
            ): IO[
              AwsError,
              zio.aws.athena.model.UpdateNotebookMetadataResponse.ReadOnly
            ] = proxy(UpdateNotebookMetadata, request)
            def getTableMetadata(request: GetTableMetadataRequest): IO[
              AwsError,
              zio.aws.athena.model.GetTableMetadataResponse.ReadOnly
            ] = proxy(GetTableMetadata, request)
            def batchGetNamedQuery(request: BatchGetNamedQueryRequest): IO[
              AwsError,
              zio.aws.athena.model.BatchGetNamedQueryResponse.ReadOnly
            ] = proxy(BatchGetNamedQuery, request)
            def listApplicationDPUSizes(
                request: ListApplicationDpuSizesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.athena.model.ApplicationDPUSizes.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListApplicationDPUSizes, request)
                }
                .getOrThrowFiberFailure()
            }
            def listApplicationDPUSizesPaginated(
                request: ListApplicationDpuSizesRequest
            ): IO[
              AwsError,
              zio.aws.athena.model.ListApplicationDpuSizesResponse.ReadOnly
            ] = proxy(ListApplicationDPUSizesPaginated, request)
            def createNamedQuery(request: CreateNamedQueryRequest): IO[
              AwsError,
              zio.aws.athena.model.CreateNamedQueryResponse.ReadOnly
            ] = proxy(CreateNamedQuery, request)
            def terminateSession(request: TerminateSessionRequest): IO[
              AwsError,
              zio.aws.athena.model.TerminateSessionResponse.ReadOnly
            ] = proxy(TerminateSession, request)
            def getDataCatalog(request: GetDataCatalogRequest): IO[
              AwsError,
              zio.aws.athena.model.GetDataCatalogResponse.ReadOnly
            ] = proxy(GetDataCatalog, request)
            def deleteNotebook(request: DeleteNotebookRequest): IO[
              AwsError,
              zio.aws.athena.model.DeleteNotebookResponse.ReadOnly
            ] = proxy(DeleteNotebook, request)
            def createNotebook(request: CreateNotebookRequest): IO[
              AwsError,
              zio.aws.athena.model.CreateNotebookResponse.ReadOnly
            ] = proxy(CreateNotebook, request)
            def listCalculationExecutions(
                request: ListCalculationExecutionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.athena.model.CalculationSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListCalculationExecutions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listCalculationExecutionsPaginated(
                request: ListCalculationExecutionsRequest
            ): IO[
              AwsError,
              zio.aws.athena.model.ListCalculationExecutionsResponse.ReadOnly
            ] = proxy(ListCalculationExecutionsPaginated, request)
            def listWorkGroups(request: ListWorkGroupsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.athena.model.WorkGroupSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListWorkGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def listWorkGroupsPaginated(request: ListWorkGroupsRequest): IO[
              AwsError,
              zio.aws.athena.model.ListWorkGroupsResponse.ReadOnly
            ] = proxy(ListWorkGroupsPaginated, request)
            def listPreparedStatements(
                request: ListPreparedStatementsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.athena.model.PreparedStatementSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPreparedStatements, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPreparedStatementsPaginated(
                request: ListPreparedStatementsRequest
            ): IO[
              AwsError,
              zio.aws.athena.model.ListPreparedStatementsResponse.ReadOnly
            ] = proxy(ListPreparedStatementsPaginated, request)
            def createPreparedStatement(
                request: CreatePreparedStatementRequest
            ): IO[
              AwsError,
              zio.aws.athena.model.CreatePreparedStatementResponse.ReadOnly
            ] = proxy(CreatePreparedStatement, request)
            def deleteDataCatalog(request: DeleteDataCatalogRequest): IO[
              AwsError,
              zio.aws.athena.model.DeleteDataCatalogResponse.ReadOnly
            ] = proxy(DeleteDataCatalog, request)
            def updateNotebook(request: UpdateNotebookRequest): IO[
              AwsError,
              zio.aws.athena.model.UpdateNotebookResponse.ReadOnly
            ] = proxy(UpdateNotebook, request)
            def listNotebookMetadata(
                request: ListNotebookMetadataRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.athena.model.NotebookMetadata.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListNotebookMetadata, request)
                }
                .getOrThrowFiberFailure()
            }
            def listNotebookMetadataPaginated(
                request: ListNotebookMetadataRequest
            ): IO[
              AwsError,
              zio.aws.athena.model.ListNotebookMetadataResponse.ReadOnly
            ] = proxy(ListNotebookMetadataPaginated, request)
            def createPresignedNotebookUrl(
                request: CreatePresignedNotebookUrlRequest
            ): IO[
              AwsError,
              zio.aws.athena.model.CreatePresignedNotebookUrlResponse.ReadOnly
            ] = proxy(CreatePresignedNotebookUrl, request)
            def getQueryExecution(request: GetQueryExecutionRequest): IO[
              AwsError,
              zio.aws.athena.model.GetQueryExecutionResponse.ReadOnly
            ] = proxy(GetQueryExecution, request)
            def updatePreparedStatement(
                request: UpdatePreparedStatementRequest
            ): IO[
              AwsError,
              zio.aws.athena.model.UpdatePreparedStatementResponse.ReadOnly
            ] = proxy(UpdatePreparedStatement, request)
            def createDataCatalog(request: CreateDataCatalogRequest): IO[
              AwsError,
              zio.aws.athena.model.CreateDataCatalogResponse.ReadOnly
            ] = proxy(CreateDataCatalog, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.athena.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def exportNotebook(request: ExportNotebookRequest): IO[
              AwsError,
              zio.aws.athena.model.ExportNotebookResponse.ReadOnly
            ] = proxy(ExportNotebook, request)
            def getSessionStatus(request: GetSessionStatusRequest): IO[
              AwsError,
              zio.aws.athena.model.GetSessionStatusResponse.ReadOnly
            ] = proxy(GetSessionStatus, request)
            def listTableMetadata(request: ListTableMetadataRequest): ZStream[
              Any,
              AwsError,
              zio.aws.athena.model.TableMetadata.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTableMetadata, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTableMetadataPaginated(
                request: ListTableMetadataRequest
            ): IO[
              AwsError,
              zio.aws.athena.model.ListTableMetadataResponse.ReadOnly
            ] = proxy(ListTableMetadataPaginated, request)
            def startCalculationExecution(
                request: StartCalculationExecutionRequest
            ): IO[AwsError, ReadOnly] =
              proxy(StartCalculationExecution, request)
            def listTagsForResource(
                request: ListTagsForResourceRequest
            ): ZStream[Any, AwsError, zio.aws.athena.model.Tag.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListTagsForResource, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listTagsForResourcePaginated(
                request: ListTagsForResourceRequest
            ): IO[
              AwsError,
              zio.aws.athena.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResourcePaginated, request)
            def tagResource(
                request: TagResourceRequest
            ): IO[AwsError, zio.aws.athena.model.TagResourceResponse.ReadOnly] =
              proxy(TagResource, request)
            def startSession(request: StartSessionRequest): IO[
              AwsError,
              zio.aws.athena.model.StartSessionResponse.ReadOnly
            ] = proxy(StartSession, request)
            def listSessions(request: ListSessionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.athena.model.SessionSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSessions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSessionsPaginated(request: ListSessionsRequest): IO[
              AwsError,
              zio.aws.athena.model.ListSessionsResponse.ReadOnly
            ] = proxy(ListSessionsPaginated, request)
            def getCalculationExecutionCode(
                request: GetCalculationExecutionCodeRequest
            ): IO[
              AwsError,
              zio.aws.athena.model.GetCalculationExecutionCodeResponse.ReadOnly
            ] = proxy(GetCalculationExecutionCode, request)
            def listNamedQueries(
                request: ListNamedQueriesRequest
            ): ZStream[Any, AwsError, NamedQueryId] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListNamedQueries, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listNamedQueriesPaginated(request: ListNamedQueriesRequest): IO[
              AwsError,
              zio.aws.athena.model.ListNamedQueriesResponse.ReadOnly
            ] = proxy(ListNamedQueriesPaginated, request)
            def deleteWorkGroup(request: DeleteWorkGroupRequest): IO[
              AwsError,
              zio.aws.athena.model.DeleteWorkGroupResponse.ReadOnly
            ] = proxy(DeleteWorkGroup, request)
            def getSession(
                request: GetSessionRequest
            ): IO[AwsError, zio.aws.athena.model.GetSessionResponse.ReadOnly] =
              proxy(GetSession, request)
            def importNotebook(request: ImportNotebookRequest): IO[
              AwsError,
              zio.aws.athena.model.ImportNotebookResponse.ReadOnly
            ] = proxy(ImportNotebook, request)
            def getDatabase(
                request: GetDatabaseRequest
            ): IO[AwsError, zio.aws.athena.model.GetDatabaseResponse.ReadOnly] =
              proxy(GetDatabase, request)
            def getCalculationExecutionStatus(
                request: GetCalculationExecutionStatusRequest
            ): IO[
              AwsError,
              zio.aws.athena.model.GetCalculationExecutionStatusResponse.ReadOnly
            ] = proxy(GetCalculationExecutionStatus, request)
            def batchGetPreparedStatement(
                request: BatchGetPreparedStatementRequest
            ): IO[
              AwsError,
              zio.aws.athena.model.BatchGetPreparedStatementResponse.ReadOnly
            ] = proxy(BatchGetPreparedStatement, request)
            def createWorkGroup(request: CreateWorkGroupRequest): IO[
              AwsError,
              zio.aws.athena.model.CreateWorkGroupResponse.ReadOnly
            ] = proxy(CreateWorkGroup, request)
            def getWorkGroup(request: GetWorkGroupRequest): IO[
              AwsError,
              zio.aws.athena.model.GetWorkGroupResponse.ReadOnly
            ] = proxy(GetWorkGroup, request)
            def batchGetQueryExecution(
                request: BatchGetQueryExecutionRequest
            ): IO[
              AwsError,
              zio.aws.athena.model.BatchGetQueryExecutionResponse.ReadOnly
            ] = proxy(BatchGetQueryExecution, request)
            def getCalculationExecution(
                request: GetCalculationExecutionRequest
            ): IO[
              AwsError,
              zio.aws.athena.model.GetCalculationExecutionResponse.ReadOnly
            ] = proxy(GetCalculationExecution, request)
            def startQueryExecution(request: StartQueryExecutionRequest): IO[
              AwsError,
              zio.aws.athena.model.StartQueryExecutionResponse.ReadOnly
            ] = proxy(StartQueryExecution, request)
            def getQueryResults(
                request: GetQueryResultsRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.athena.model.ResultSetMetadata.ReadOnly,
              zio.aws.athena.model.Row.ReadOnly
            ]] = proxy(GetQueryResults, request)
            def getQueryResultsPaginated(request: GetQueryResultsRequest): IO[
              AwsError,
              zio.aws.athena.model.GetQueryResultsResponse.ReadOnly
            ] = proxy(GetQueryResultsPaginated, request)
            def stopQueryExecution(request: StopQueryExecutionRequest): IO[
              AwsError,
              zio.aws.athena.model.StopQueryExecutionResponse.ReadOnly
            ] = proxy(StopQueryExecution, request)
          }
        }
      }
    }
  }
}
