package zio.aws.athena.model
import zio.aws.athena.model.primitives.{AwsAccountId, ResultOutputLocation}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResultConfiguration(
    outputLocation: Optional[ResultOutputLocation] = Optional.Absent,
    encryptionConfiguration: Optional[
      zio.aws.athena.model.EncryptionConfiguration
    ] = Optional.Absent,
    expectedBucketOwner: Optional[AwsAccountId] = Optional.Absent,
    aclConfiguration: Optional[zio.aws.athena.model.AclConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ResultConfiguration = {
    import ResultConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ResultConfiguration
      .builder()
      .optionallyWith(
        outputLocation.map(value =>
          ResultOutputLocation.unwrap(value): java.lang.String
        )
      )(_.outputLocation)
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AwsAccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .optionallyWith(aclConfiguration.map(value => value.buildAwsValue()))(
        _.aclConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ResultConfiguration.ReadOnly =
    zio.aws.athena.model.ResultConfiguration.wrap(buildAwsValue())
}
object ResultConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ResultConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ResultConfiguration =
      zio.aws.athena.model.ResultConfiguration(
        outputLocation.map(value => value),
        encryptionConfiguration.map(value => value.asEditable),
        expectedBucketOwner.map(value => value),
        aclConfiguration.map(value => value.asEditable)
      )
    def outputLocation: Optional[ResultOutputLocation]
    def encryptionConfiguration
        : Optional[zio.aws.athena.model.EncryptionConfiguration.ReadOnly]
    def expectedBucketOwner: Optional[AwsAccountId]
    def aclConfiguration
        : Optional[zio.aws.athena.model.AclConfiguration.ReadOnly]
    def getOutputLocation: ZIO[Any, AwsError, ResultOutputLocation] =
      AwsError.unwrapOptionField("outputLocation", outputLocation)
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.EncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
    def getExpectedBucketOwner: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
    def getAclConfiguration
        : ZIO[Any, AwsError, zio.aws.athena.model.AclConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("aclConfiguration", aclConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ResultConfiguration
  ) extends zio.aws.athena.model.ResultConfiguration.ReadOnly {
    override val outputLocation: Optional[ResultOutputLocation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputLocation())
        .map(value =>
          zio.aws.athena.model.primitives.ResultOutputLocation(value)
        )
    override val encryptionConfiguration
        : Optional[zio.aws.athena.model.EncryptionConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionConfiguration())
        .map(value => zio.aws.athena.model.EncryptionConfiguration.wrap(value))
    override val expectedBucketOwner: Optional[AwsAccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.athena.model.primitives.AwsAccountId(value))
    override val aclConfiguration
        : Optional[zio.aws.athena.model.AclConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aclConfiguration())
        .map(value => zio.aws.athena.model.AclConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ResultConfiguration
  ): zio.aws.athena.model.ResultConfiguration.ReadOnly = new Wrapper(impl)
}
