package zio.aws.athena.model
import zio.aws.athena.model.primitives.SessionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetSessionStatusRequest(sessionId: SessionId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetSessionStatusRequest = {
    import GetSessionStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetSessionStatusRequest
      .builder()
      .sessionId(SessionId.unwrap(sessionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.GetSessionStatusRequest.ReadOnly =
    zio.aws.athena.model.GetSessionStatusRequest.wrap(buildAwsValue())
}
object GetSessionStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetSessionStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetSessionStatusRequest =
      zio.aws.athena.model.GetSessionStatusRequest(sessionId)
    def sessionId: SessionId
    def getSessionId: ZIO[Any, Nothing, SessionId] = ZIO.succeed(sessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetSessionStatusRequest
  ) extends zio.aws.athena.model.GetSessionStatusRequest.ReadOnly {
    override val sessionId: SessionId =
      zio.aws.athena.model.primitives.SessionId(impl.sessionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetSessionStatusRequest
  ): zio.aws.athena.model.GetSessionStatusRequest.ReadOnly = new Wrapper(impl)
}
