package zio.aws.athena.model
import zio.aws.athena.model.primitives.CalculationExecutionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetCalculationExecutionStatusRequest(
    calculationExecutionId: CalculationExecutionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetCalculationExecutionStatusRequest = {
    import GetCalculationExecutionStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetCalculationExecutionStatusRequest
      .builder()
      .calculationExecutionId(
        CalculationExecutionId.unwrap(calculationExecutionId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.GetCalculationExecutionStatusRequest.ReadOnly =
    zio.aws.athena.model.GetCalculationExecutionStatusRequest
      .wrap(buildAwsValue())
}
object GetCalculationExecutionStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetCalculationExecutionStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetCalculationExecutionStatusRequest =
      zio.aws.athena.model
        .GetCalculationExecutionStatusRequest(calculationExecutionId)
    def calculationExecutionId: CalculationExecutionId
    def getCalculationExecutionId: ZIO[Any, Nothing, CalculationExecutionId] =
      ZIO.succeed(calculationExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetCalculationExecutionStatusRequest
  ) extends zio.aws.athena.model.GetCalculationExecutionStatusRequest.ReadOnly {
    override val calculationExecutionId: CalculationExecutionId =
      zio.aws.athena.model.primitives
        .CalculationExecutionId(impl.calculationExecutionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetCalculationExecutionStatusRequest
  ): zio.aws.athena.model.GetCalculationExecutionStatusRequest.ReadOnly =
    new Wrapper(impl)
}
