package zio.aws.athena.model
import zio.aws.athena.model.primitives.{Integer, NameString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ApplicationDPUSizes(
    applicationRuntimeId: Optional[NameString] = Optional.Absent,
    supportedDPUSizes: Optional[Iterable[Integer]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ApplicationDPUSizes = {
    import ApplicationDPUSizes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ApplicationDPUSizes
      .builder()
      .optionallyWith(
        applicationRuntimeId.map(value =>
          NameString.unwrap(value): java.lang.String
        )
      )(_.applicationRuntimeId)
      .optionallyWith(
        supportedDPUSizes.map(value =>
          value.map { item =>
            item: java.lang.Integer
          }.asJavaCollection
        )
      )(_.supportedDPUSizes)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ApplicationDPUSizes.ReadOnly =
    zio.aws.athena.model.ApplicationDPUSizes.wrap(buildAwsValue())
}
object ApplicationDPUSizes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ApplicationDPUSizes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ApplicationDPUSizes =
      zio.aws.athena.model.ApplicationDPUSizes(
        applicationRuntimeId.map(value => value),
        supportedDPUSizes.map(value => value)
      )
    def applicationRuntimeId: Optional[NameString]
    def supportedDPUSizes: Optional[List[Integer]]
    def getApplicationRuntimeId: ZIO[Any, AwsError, NameString] =
      AwsError.unwrapOptionField("applicationRuntimeId", applicationRuntimeId)
    def getSupportedDPUSizes: ZIO[Any, AwsError, List[Integer]] =
      AwsError.unwrapOptionField("supportedDPUSizes", supportedDPUSizes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ApplicationDPUSizes
  ) extends zio.aws.athena.model.ApplicationDPUSizes.ReadOnly {
    override val applicationRuntimeId: Optional[NameString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationRuntimeId())
        .map(value => zio.aws.athena.model.primitives.NameString(value))
    override val supportedDPUSizes: Optional[List[Integer]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedDPUSizes())
        .map(value =>
          value.asScala.map { item =>
            item: Integer
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ApplicationDPUSizes
  ): zio.aws.athena.model.ApplicationDPUSizes.ReadOnly = new Wrapper(impl)
}
