package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class QueryStage(
    stageId: Optional[Long] = Optional.Absent,
    state: Optional[String] = Optional.Absent,
    outputBytes: Optional[Long] = Optional.Absent,
    outputRows: Optional[Long] = Optional.Absent,
    inputBytes: Optional[Long] = Optional.Absent,
    inputRows: Optional[Long] = Optional.Absent,
    executionTime: Optional[Long] = Optional.Absent,
    queryStagePlan: Optional[zio.aws.athena.model.QueryStagePlanNode] =
      Optional.Absent,
    subStages: Optional[Iterable[zio.aws.athena.model.QueryStage]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.QueryStage = {
    import QueryStage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.QueryStage
      .builder()
      .optionallyWith(stageId.map(value => value: java.lang.Long))(_.stageId)
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(outputBytes.map(value => value: java.lang.Long))(
        _.outputBytes
      )
      .optionallyWith(outputRows.map(value => value: java.lang.Long))(
        _.outputRows
      )
      .optionallyWith(inputBytes.map(value => value: java.lang.Long))(
        _.inputBytes
      )
      .optionallyWith(inputRows.map(value => value: java.lang.Long))(
        _.inputRows
      )
      .optionallyWith(executionTime.map(value => value: java.lang.Long))(
        _.executionTime
      )
      .optionallyWith(queryStagePlan.map(value => value.buildAwsValue()))(
        _.queryStagePlan
      )
      .optionallyWith(
        subStages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subStages)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.QueryStage.ReadOnly =
    zio.aws.athena.model.QueryStage.wrap(buildAwsValue())
}
object QueryStage {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.athena.model.QueryStage] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.QueryStage =
      zio.aws.athena.model.QueryStage(
        stageId.map(value => value),
        state.map(value => value),
        outputBytes.map(value => value),
        outputRows.map(value => value),
        inputBytes.map(value => value),
        inputRows.map(value => value),
        executionTime.map(value => value),
        queryStagePlan.map(value => value.asEditable),
        subStages.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def stageId: Optional[Long]
    def state: Optional[String]
    def outputBytes: Optional[Long]
    def outputRows: Optional[Long]
    def inputBytes: Optional[Long]
    def inputRows: Optional[Long]
    def executionTime: Optional[Long]
    def queryStagePlan
        : Optional[zio.aws.athena.model.QueryStagePlanNode.ReadOnly]
    def subStages: Optional[List[zio.aws.athena.model.QueryStage.ReadOnly]]
    def getStageId: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("stageId", stageId)
    def getState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("state", state)
    def getOutputBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("outputBytes", outputBytes)
    def getOutputRows: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("outputRows", outputRows)
    def getInputBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("inputBytes", inputBytes)
    def getInputRows: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("inputRows", inputRows)
    def getExecutionTime: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("executionTime", executionTime)
    def getQueryStagePlan
        : ZIO[Any, AwsError, zio.aws.athena.model.QueryStagePlanNode.ReadOnly] =
      AwsError.unwrapOptionField("queryStagePlan", queryStagePlan)
    def getSubStages
        : ZIO[Any, AwsError, List[zio.aws.athena.model.QueryStage.ReadOnly]] =
      AwsError.unwrapOptionField("subStages", subStages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.QueryStage
  ) extends zio.aws.athena.model.QueryStage.ReadOnly {
    override val stageId: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.stageId())
      .map(value => value: Long)
    override val state: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => value: String)
    override val outputBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.outputBytes())
      .map(value => value: Long)
    override val outputRows: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.outputRows())
      .map(value => value: Long)
    override val inputBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.inputBytes())
      .map(value => value: Long)
    override val inputRows: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.inputRows())
      .map(value => value: Long)
    override val executionTime: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.executionTime())
      .map(value => value: Long)
    override val queryStagePlan
        : Optional[zio.aws.athena.model.QueryStagePlanNode.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryStagePlan())
        .map(value => zio.aws.athena.model.QueryStagePlanNode.wrap(value))
    override val subStages
        : Optional[List[zio.aws.athena.model.QueryStage.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subStages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.athena.model.QueryStage.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.QueryStage
  ): zio.aws.athena.model.QueryStage.ReadOnly = new Wrapper(impl)
}
