package zio.aws.athena.model
import scala.jdk.CollectionConverters.*
sealed trait WorkGroupState {
  def unwrap: software.amazon.awssdk.services.athena.model.WorkGroupState
}
object WorkGroupState {
  def wrap(
      value: software.amazon.awssdk.services.athena.model.WorkGroupState
  ): zio.aws.athena.model.WorkGroupState = value match {
    case software.amazon.awssdk.services.athena.model.WorkGroupState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.athena.model.WorkGroupState.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.athena.model.WorkGroupState.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.athena.model.WorkGroupState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.WorkGroupState =
      software.amazon.awssdk.services.athena.model.WorkGroupState.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.athena.model.WorkGroupState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.WorkGroupState =
      software.amazon.awssdk.services.athena.model.WorkGroupState.ENABLED
  }
  case object DISABLED extends zio.aws.athena.model.WorkGroupState {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.WorkGroupState =
      software.amazon.awssdk.services.athena.model.WorkGroupState.DISABLED
  }
}
