package zio.aws.athena.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.{
  MaxTableMetadataCount,
  Token,
  CatalogNameString,
  NameString,
  ExpressionString
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListTableMetadataRequest(
    catalogName: CatalogNameString,
    databaseName: NameString,
    expression: Optional[ExpressionString] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[MaxTableMetadataCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListTableMetadataRequest = {
    import ListTableMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListTableMetadataRequest
      .builder()
      .catalogName(CatalogNameString.unwrap(catalogName): java.lang.String)
      .databaseName(NameString.unwrap(databaseName): java.lang.String)
      .optionallyWith(
        expression.map(value =>
          ExpressionString.unwrap(value): java.lang.String
        )
      )(_.expression)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxTableMetadataCount.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListTableMetadataRequest.ReadOnly =
    zio.aws.athena.model.ListTableMetadataRequest.wrap(buildAwsValue())
}
object ListTableMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListTableMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListTableMetadataRequest =
      zio.aws.athena.model.ListTableMetadataRequest(
        catalogName,
        databaseName,
        expression.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def catalogName: CatalogNameString
    def databaseName: NameString
    def expression: Optional[ExpressionString]
    def nextToken: Optional[Token]
    def maxResults: Optional[MaxTableMetadataCount]
    def getCatalogName: ZIO[Any, Nothing, CatalogNameString] =
      ZIO.succeed(catalogName)
    def getDatabaseName: ZIO[Any, Nothing, NameString] =
      ZIO.succeed(databaseName)
    def getExpression: ZIO[Any, AwsError, ExpressionString] =
      AwsError.unwrapOptionField("expression", expression)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxTableMetadataCount] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListTableMetadataRequest
  ) extends zio.aws.athena.model.ListTableMetadataRequest.ReadOnly {
    override val catalogName: CatalogNameString =
      zio.aws.athena.model.primitives.CatalogNameString(impl.catalogName())
    override val databaseName: NameString =
      zio.aws.athena.model.primitives.NameString(impl.databaseName())
    override val expression: Optional[ExpressionString] = zio.aws.core.internal
      .optionalFromNullable(impl.expression())
      .map(value => zio.aws.athena.model.primitives.ExpressionString(value))
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
    override val maxResults: Optional[MaxTableMetadataCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.athena.model.primitives.MaxTableMetadataCount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListTableMetadataRequest
  ): zio.aws.athena.model.ListTableMetadataRequest.ReadOnly = new Wrapper(impl)
}
