package zio.aws.athena.model
import zio.aws.athena.model.primitives.{CatalogNameString, DatabaseString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class QueryExecutionContext(
    database: Optional[DatabaseString] = Optional.Absent,
    catalog: Optional[CatalogNameString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.QueryExecutionContext = {
    import QueryExecutionContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.QueryExecutionContext
      .builder()
      .optionallyWith(
        database.map(value => DatabaseString.unwrap(value): java.lang.String)
      )(_.database)
      .optionallyWith(
        catalog.map(value => CatalogNameString.unwrap(value): java.lang.String)
      )(_.catalog)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.QueryExecutionContext.ReadOnly =
    zio.aws.athena.model.QueryExecutionContext.wrap(buildAwsValue())
}
object QueryExecutionContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.QueryExecutionContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.QueryExecutionContext =
      zio.aws.athena.model.QueryExecutionContext(
        database.map(value => value),
        catalog.map(value => value)
      )
    def database: Optional[DatabaseString]
    def catalog: Optional[CatalogNameString]
    def getDatabase: ZIO[Any, AwsError, DatabaseString] =
      AwsError.unwrapOptionField("database", database)
    def getCatalog: ZIO[Any, AwsError, CatalogNameString] =
      AwsError.unwrapOptionField("catalog", catalog)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.QueryExecutionContext
  ) extends zio.aws.athena.model.QueryExecutionContext.ReadOnly {
    override val database: Optional[DatabaseString] = zio.aws.core.internal
      .optionalFromNullable(impl.database())
      .map(value => zio.aws.athena.model.primitives.DatabaseString(value))
    override val catalog: Optional[CatalogNameString] = zio.aws.core.internal
      .optionalFromNullable(impl.catalog())
      .map(value => zio.aws.athena.model.primitives.CatalogNameString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.QueryExecutionContext
  ): zio.aws.athena.model.QueryExecutionContext.ReadOnly = new Wrapper(impl)
}
