package zio.aws.athena.model
import zio.aws.athena.model.primitives.{
  ExecutionParameter,
  WorkGroupName,
  QueryString,
  QueryExecutionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class QueryExecution(
    queryExecutionId: Optional[QueryExecutionId] = Optional.Absent,
    query: Optional[QueryString] = Optional.Absent,
    statementType: Optional[zio.aws.athena.model.StatementType] =
      Optional.Absent,
    resultConfiguration: Optional[zio.aws.athena.model.ResultConfiguration] =
      Optional.Absent,
    queryExecutionContext: Optional[
      zio.aws.athena.model.QueryExecutionContext
    ] = Optional.Absent,
    status: Optional[zio.aws.athena.model.QueryExecutionStatus] =
      Optional.Absent,
    statistics: Optional[zio.aws.athena.model.QueryExecutionStatistics] =
      Optional.Absent,
    workGroup: Optional[WorkGroupName] = Optional.Absent,
    engineVersion: Optional[zio.aws.athena.model.EngineVersion] =
      Optional.Absent,
    executionParameters: Optional[Iterable[ExecutionParameter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.QueryExecution = {
    import QueryExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.QueryExecution
      .builder()
      .optionallyWith(
        queryExecutionId.map(value =>
          QueryExecutionId.unwrap(value): java.lang.String
        )
      )(_.queryExecutionId)
      .optionallyWith(
        query.map(value => QueryString.unwrap(value): java.lang.String)
      )(_.query)
      .optionallyWith(statementType.map(value => value.unwrap))(_.statementType)
      .optionallyWith(resultConfiguration.map(value => value.buildAwsValue()))(
        _.resultConfiguration
      )
      .optionallyWith(
        queryExecutionContext.map(value => value.buildAwsValue())
      )(_.queryExecutionContext)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(statistics.map(value => value.buildAwsValue()))(
        _.statistics
      )
      .optionallyWith(
        workGroup.map(value => WorkGroupName.unwrap(value): java.lang.String)
      )(_.workGroup)
      .optionallyWith(engineVersion.map(value => value.buildAwsValue()))(
        _.engineVersion
      )
      .optionallyWith(
        executionParameters.map(value =>
          value.map { item =>
            ExecutionParameter.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.executionParameters)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.QueryExecution.ReadOnly =
    zio.aws.athena.model.QueryExecution.wrap(buildAwsValue())
}
object QueryExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.QueryExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.QueryExecution =
      zio.aws.athena.model.QueryExecution(
        queryExecutionId.map(value => value),
        query.map(value => value),
        statementType.map(value => value),
        resultConfiguration.map(value => value.asEditable),
        queryExecutionContext.map(value => value.asEditable),
        status.map(value => value.asEditable),
        statistics.map(value => value.asEditable),
        workGroup.map(value => value),
        engineVersion.map(value => value.asEditable),
        executionParameters.map(value => value)
      )
    def queryExecutionId: Optional[QueryExecutionId]
    def query: Optional[QueryString]
    def statementType: Optional[zio.aws.athena.model.StatementType]
    def resultConfiguration
        : Optional[zio.aws.athena.model.ResultConfiguration.ReadOnly]
    def queryExecutionContext
        : Optional[zio.aws.athena.model.QueryExecutionContext.ReadOnly]
    def status: Optional[zio.aws.athena.model.QueryExecutionStatus.ReadOnly]
    def statistics
        : Optional[zio.aws.athena.model.QueryExecutionStatistics.ReadOnly]
    def workGroup: Optional[WorkGroupName]
    def engineVersion: Optional[zio.aws.athena.model.EngineVersion.ReadOnly]
    def executionParameters: Optional[List[ExecutionParameter]]
    def getQueryExecutionId: ZIO[Any, AwsError, QueryExecutionId] =
      AwsError.unwrapOptionField("queryExecutionId", queryExecutionId)
    def getQuery: ZIO[Any, AwsError, QueryString] =
      AwsError.unwrapOptionField("query", query)
    def getStatementType
        : ZIO[Any, AwsError, zio.aws.athena.model.StatementType] =
      AwsError.unwrapOptionField("statementType", statementType)
    def getResultConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.ResultConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("resultConfiguration", resultConfiguration)
    def getQueryExecutionContext: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.QueryExecutionContext.ReadOnly
    ] =
      AwsError.unwrapOptionField("queryExecutionContext", queryExecutionContext)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.QueryExecutionStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getStatistics: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.QueryExecutionStatistics.ReadOnly
    ] = AwsError.unwrapOptionField("statistics", statistics)
    def getWorkGroup: ZIO[Any, AwsError, WorkGroupName] =
      AwsError.unwrapOptionField("workGroup", workGroup)
    def getEngineVersion
        : ZIO[Any, AwsError, zio.aws.athena.model.EngineVersion.ReadOnly] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getExecutionParameters: ZIO[Any, AwsError, List[ExecutionParameter]] =
      AwsError.unwrapOptionField("executionParameters", executionParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.QueryExecution
  ) extends zio.aws.athena.model.QueryExecution.ReadOnly {
    override val queryExecutionId: Optional[QueryExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryExecutionId())
        .map(value => zio.aws.athena.model.primitives.QueryExecutionId(value))
    override val query: Optional[QueryString] = zio.aws.core.internal
      .optionalFromNullable(impl.query())
      .map(value => zio.aws.athena.model.primitives.QueryString(value))
    override val statementType: Optional[zio.aws.athena.model.StatementType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statementType())
        .map(value => zio.aws.athena.model.StatementType.wrap(value))
    override val resultConfiguration
        : Optional[zio.aws.athena.model.ResultConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resultConfiguration())
        .map(value => zio.aws.athena.model.ResultConfiguration.wrap(value))
    override val queryExecutionContext
        : Optional[zio.aws.athena.model.QueryExecutionContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryExecutionContext())
        .map(value => zio.aws.athena.model.QueryExecutionContext.wrap(value))
    override val status
        : Optional[zio.aws.athena.model.QueryExecutionStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.athena.model.QueryExecutionStatus.wrap(value))
    override val statistics
        : Optional[zio.aws.athena.model.QueryExecutionStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistics())
        .map(value => zio.aws.athena.model.QueryExecutionStatistics.wrap(value))
    override val workGroup: Optional[WorkGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.workGroup())
      .map(value => zio.aws.athena.model.primitives.WorkGroupName(value))
    override val engineVersion
        : Optional[zio.aws.athena.model.EngineVersion.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engineVersion())
        .map(value => zio.aws.athena.model.EngineVersion.wrap(value))
    override val executionParameters: Optional[List[ExecutionParameter]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionParameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.athena.model.primitives.ExecutionParameter(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.QueryExecution
  ): zio.aws.athena.model.QueryExecution.ReadOnly = new Wrapper(impl)
}
