package zio.aws.athena.model
import zio.aws.athena.model.primitives.{WorkGroupName, StatementName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchGetPreparedStatementRequest(
    preparedStatementNames: Iterable[StatementName],
    workGroup: WorkGroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.BatchGetPreparedStatementRequest = {
    import BatchGetPreparedStatementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.BatchGetPreparedStatementRequest
      .builder()
      .preparedStatementNames(preparedStatementNames.map { item =>
        StatementName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .workGroup(WorkGroupName.unwrap(workGroup): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.BatchGetPreparedStatementRequest.ReadOnly =
    zio.aws.athena.model.BatchGetPreparedStatementRequest.wrap(buildAwsValue())
}
object BatchGetPreparedStatementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.BatchGetPreparedStatementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.BatchGetPreparedStatementRequest =
      zio.aws.athena.model
        .BatchGetPreparedStatementRequest(preparedStatementNames, workGroup)
    def preparedStatementNames: List[StatementName]
    def workGroup: WorkGroupName
    def getPreparedStatementNames: ZIO[Any, Nothing, List[StatementName]] =
      ZIO.succeed(preparedStatementNames)
    def getWorkGroup: ZIO[Any, Nothing, WorkGroupName] = ZIO.succeed(workGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.BatchGetPreparedStatementRequest
  ) extends zio.aws.athena.model.BatchGetPreparedStatementRequest.ReadOnly {
    override val preparedStatementNames: List[StatementName] = impl
      .preparedStatementNames()
      .asScala
      .map { item =>
        zio.aws.athena.model.primitives.StatementName(item)
      }
      .toList
    override val workGroup: WorkGroupName =
      zio.aws.athena.model.primitives.WorkGroupName(impl.workGroup())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.BatchGetPreparedStatementRequest
  ): zio.aws.athena.model.BatchGetPreparedStatementRequest.ReadOnly =
    new Wrapper(impl)
}
