package zio.aws.athena.model
import zio.aws.athena.model.primitives.{BytesScannedCutoffValue, BoxedBoolean}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class WorkGroupConfiguration(
    resultConfiguration: Optional[zio.aws.athena.model.ResultConfiguration] =
      Optional.Absent,
    enforceWorkGroupConfiguration: Optional[BoxedBoolean] = Optional.Absent,
    publishCloudWatchMetricsEnabled: Optional[BoxedBoolean] = Optional.Absent,
    bytesScannedCutoffPerQuery: Optional[BytesScannedCutoffValue] =
      Optional.Absent,
    requesterPaysEnabled: Optional[BoxedBoolean] = Optional.Absent,
    engineVersion: Optional[zio.aws.athena.model.EngineVersion] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.WorkGroupConfiguration = {
    import WorkGroupConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.WorkGroupConfiguration
      .builder()
      .optionallyWith(resultConfiguration.map(value => value.buildAwsValue()))(
        _.resultConfiguration
      )
      .optionallyWith(
        enforceWorkGroupConfiguration.map(value => value: java.lang.Boolean)
      )(_.enforceWorkGroupConfiguration)
      .optionallyWith(
        publishCloudWatchMetricsEnabled.map(value => value: java.lang.Boolean)
      )(_.publishCloudWatchMetricsEnabled)
      .optionallyWith(
        bytesScannedCutoffPerQuery.map(value =>
          BytesScannedCutoffValue.unwrap(value): java.lang.Long
        )
      )(_.bytesScannedCutoffPerQuery)
      .optionallyWith(
        requesterPaysEnabled.map(value => value: java.lang.Boolean)
      )(_.requesterPaysEnabled)
      .optionallyWith(engineVersion.map(value => value.buildAwsValue()))(
        _.engineVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.WorkGroupConfiguration.ReadOnly =
    zio.aws.athena.model.WorkGroupConfiguration.wrap(buildAwsValue())
}
object WorkGroupConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.WorkGroupConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.WorkGroupConfiguration =
      zio.aws.athena.model.WorkGroupConfiguration(
        resultConfiguration.map(value => value.asEditable),
        enforceWorkGroupConfiguration.map(value => value),
        publishCloudWatchMetricsEnabled.map(value => value),
        bytesScannedCutoffPerQuery.map(value => value),
        requesterPaysEnabled.map(value => value),
        engineVersion.map(value => value.asEditable)
      )
    def resultConfiguration
        : Optional[zio.aws.athena.model.ResultConfiguration.ReadOnly]
    def enforceWorkGroupConfiguration: Optional[BoxedBoolean]
    def publishCloudWatchMetricsEnabled: Optional[BoxedBoolean]
    def bytesScannedCutoffPerQuery: Optional[BytesScannedCutoffValue]
    def requesterPaysEnabled: Optional[BoxedBoolean]
    def engineVersion: Optional[zio.aws.athena.model.EngineVersion.ReadOnly]
    def getResultConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.ResultConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("resultConfiguration", resultConfiguration)
    def getEnforceWorkGroupConfiguration: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField(
        "enforceWorkGroupConfiguration",
        enforceWorkGroupConfiguration
      )
    def getPublishCloudWatchMetricsEnabled: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField(
        "publishCloudWatchMetricsEnabled",
        publishCloudWatchMetricsEnabled
      )
    def getBytesScannedCutoffPerQuery
        : ZIO[Any, AwsError, BytesScannedCutoffValue] =
      AwsError.unwrapOptionField(
        "bytesScannedCutoffPerQuery",
        bytesScannedCutoffPerQuery
      )
    def getRequesterPaysEnabled: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("requesterPaysEnabled", requesterPaysEnabled)
    def getEngineVersion
        : ZIO[Any, AwsError, zio.aws.athena.model.EngineVersion.ReadOnly] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.WorkGroupConfiguration
  ) extends zio.aws.athena.model.WorkGroupConfiguration.ReadOnly {
    override val resultConfiguration
        : Optional[zio.aws.athena.model.ResultConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resultConfiguration())
        .map(value => zio.aws.athena.model.ResultConfiguration.wrap(value))
    override val enforceWorkGroupConfiguration: Optional[BoxedBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enforceWorkGroupConfiguration())
        .map(value => value: BoxedBoolean)
    override val publishCloudWatchMetricsEnabled: Optional[BoxedBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publishCloudWatchMetricsEnabled())
        .map(value => value: BoxedBoolean)
    override val bytesScannedCutoffPerQuery: Optional[BytesScannedCutoffValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bytesScannedCutoffPerQuery())
        .map(value =>
          zio.aws.athena.model.primitives.BytesScannedCutoffValue(value)
        )
    override val requesterPaysEnabled: Optional[BoxedBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requesterPaysEnabled())
        .map(value => value: BoxedBoolean)
    override val engineVersion
        : Optional[zio.aws.athena.model.EngineVersion.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engineVersion())
        .map(value => zio.aws.athena.model.EngineVersion.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.WorkGroupConfiguration
  ): zio.aws.athena.model.WorkGroupConfiguration.ReadOnly = new Wrapper(impl)
}
