package zio.aws.athena.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.{Date, StatementName}
import scala.jdk.CollectionConverters.*
final case class PreparedStatementSummary(
    statementName: Optional[StatementName] = Optional.Absent,
    lastModifiedTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.PreparedStatementSummary = {
    import PreparedStatementSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.PreparedStatementSummary
      .builder()
      .optionallyWith(
        statementName.map(value =>
          StatementName.unwrap(value): java.lang.String
        )
      )(_.statementName)
      .optionallyWith(
        lastModifiedTime.map(value => Date.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.PreparedStatementSummary.ReadOnly =
    zio.aws.athena.model.PreparedStatementSummary.wrap(buildAwsValue())
}
object PreparedStatementSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.PreparedStatementSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.PreparedStatementSummary =
      zio.aws.athena.model.PreparedStatementSummary(
        statementName.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def statementName: Optional[StatementName]
    def lastModifiedTime: Optional[Date]
    def getStatementName: ZIO[Any, AwsError, StatementName] =
      AwsError.unwrapOptionField("statementName", statementName)
    def getLastModifiedTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.PreparedStatementSummary
  ) extends zio.aws.athena.model.PreparedStatementSummary.ReadOnly {
    override val statementName: Optional[StatementName] = zio.aws.core.internal
      .optionalFromNullable(impl.statementName())
      .map(value => zio.aws.athena.model.primitives.StatementName(value))
    override val lastModifiedTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.athena.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.PreparedStatementSummary
  ): zio.aws.athena.model.PreparedStatementSummary.ReadOnly = new Wrapper(impl)
}
