package zio.aws.athena.model
import zio.aws.athena.model.primitives.{
  DescriptionString,
  QueryString,
  WorkGroupName,
  StatementName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreatePreparedStatementRequest(
    statementName: StatementName,
    workGroup: WorkGroupName,
    queryStatement: QueryString,
    description: Optional[DescriptionString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.CreatePreparedStatementRequest = {
    import CreatePreparedStatementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.CreatePreparedStatementRequest
      .builder()
      .statementName(StatementName.unwrap(statementName): java.lang.String)
      .workGroup(WorkGroupName.unwrap(workGroup): java.lang.String)
      .queryStatement(QueryString.unwrap(queryStatement): java.lang.String)
      .optionallyWith(
        description.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.CreatePreparedStatementRequest.ReadOnly =
    zio.aws.athena.model.CreatePreparedStatementRequest.wrap(buildAwsValue())
}
object CreatePreparedStatementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.CreatePreparedStatementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.CreatePreparedStatementRequest =
      zio.aws.athena.model.CreatePreparedStatementRequest(
        statementName,
        workGroup,
        queryStatement,
        description.map(value => value)
      )
    def statementName: StatementName
    def workGroup: WorkGroupName
    def queryStatement: QueryString
    def description: Optional[DescriptionString]
    def getStatementName: ZIO[Any, Nothing, StatementName] =
      ZIO.succeed(statementName)
    def getWorkGroup: ZIO[Any, Nothing, WorkGroupName] = ZIO.succeed(workGroup)
    def getQueryStatement: ZIO[Any, Nothing, QueryString] =
      ZIO.succeed(queryStatement)
    def getDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.CreatePreparedStatementRequest
  ) extends zio.aws.athena.model.CreatePreparedStatementRequest.ReadOnly {
    override val statementName: StatementName =
      zio.aws.athena.model.primitives.StatementName(impl.statementName())
    override val workGroup: WorkGroupName =
      zio.aws.athena.model.primitives.WorkGroupName(impl.workGroup())
    override val queryStatement: QueryString =
      zio.aws.athena.model.primitives.QueryString(impl.queryStatement())
    override val description: Optional[DescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.athena.model.primitives.DescriptionString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.CreatePreparedStatementRequest
  ): zio.aws.athena.model.CreatePreparedStatementRequest.ReadOnly = new Wrapper(
    impl
  )
}
