package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResultSet(
    rows: Optional[Iterable[zio.aws.athena.model.Row]] = Optional.Absent,
    resultSetMetadata: Optional[zio.aws.athena.model.ResultSetMetadata] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ResultSet = {
    import ResultSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ResultSet
      .builder()
      .optionallyWith(
        rows.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rows)
      .optionallyWith(resultSetMetadata.map(value => value.buildAwsValue()))(
        _.resultSetMetadata
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ResultSet.ReadOnly =
    zio.aws.athena.model.ResultSet.wrap(buildAwsValue())
}
object ResultSet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.athena.model.ResultSet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ResultSet =
      zio.aws.athena.model.ResultSet(
        rows.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resultSetMetadata.map(value => value.asEditable)
      )
    def rows: Optional[List[zio.aws.athena.model.Row.ReadOnly]]
    def resultSetMetadata
        : Optional[zio.aws.athena.model.ResultSetMetadata.ReadOnly]
    def getRows: ZIO[Any, AwsError, List[zio.aws.athena.model.Row.ReadOnly]] =
      AwsError.unwrapOptionField("rows", rows)
    def getResultSetMetadata
        : ZIO[Any, AwsError, zio.aws.athena.model.ResultSetMetadata.ReadOnly] =
      AwsError.unwrapOptionField("resultSetMetadata", resultSetMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ResultSet
  ) extends zio.aws.athena.model.ResultSet.ReadOnly {
    override val rows: Optional[List[zio.aws.athena.model.Row.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rows())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.athena.model.Row.wrap(item)
          }.toList
        )
    override val resultSetMetadata
        : Optional[zio.aws.athena.model.ResultSetMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resultSetMetadata())
        .map(value => zio.aws.athena.model.ResultSetMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ResultSet
  ): zio.aws.athena.model.ResultSet.ReadOnly = new Wrapper(impl)
}
