package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetDatabaseResponse(
    database: Optional[zio.aws.athena.model.Database] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetDatabaseResponse = {
    import GetDatabaseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetDatabaseResponse
      .builder()
      .optionallyWith(database.map(value => value.buildAwsValue()))(_.database)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.GetDatabaseResponse.ReadOnly =
    zio.aws.athena.model.GetDatabaseResponse.wrap(buildAwsValue())
}
object GetDatabaseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetDatabaseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetDatabaseResponse =
      zio.aws.athena.model
        .GetDatabaseResponse(database.map(value => value.asEditable))
    def database: Optional[zio.aws.athena.model.Database.ReadOnly]
    def getDatabase
        : ZIO[Any, AwsError, zio.aws.athena.model.Database.ReadOnly] =
      AwsError.unwrapOptionField("database", database)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetDatabaseResponse
  ) extends zio.aws.athena.model.GetDatabaseResponse.ReadOnly {
    override val database: Optional[zio.aws.athena.model.Database.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.database())
        .map(value => zio.aws.athena.model.Database.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetDatabaseResponse
  ): zio.aws.athena.model.GetDatabaseResponse.ReadOnly = new Wrapper(impl)
}
