package zio.aws.athena.model
import zio.aws.athena.model.primitives.{WorkGroupName, StatementName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeletePreparedStatementRequest(
    statementName: StatementName,
    workGroup: WorkGroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.DeletePreparedStatementRequest = {
    import DeletePreparedStatementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.DeletePreparedStatementRequest
      .builder()
      .statementName(StatementName.unwrap(statementName): java.lang.String)
      .workGroup(WorkGroupName.unwrap(workGroup): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.DeletePreparedStatementRequest.ReadOnly =
    zio.aws.athena.model.DeletePreparedStatementRequest.wrap(buildAwsValue())
}
object DeletePreparedStatementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.DeletePreparedStatementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.DeletePreparedStatementRequest =
      zio.aws.athena.model
        .DeletePreparedStatementRequest(statementName, workGroup)
    def statementName: StatementName
    def workGroup: WorkGroupName
    def getStatementName: ZIO[Any, Nothing, StatementName] =
      ZIO.succeed(statementName)
    def getWorkGroup: ZIO[Any, Nothing, WorkGroupName] = ZIO.succeed(workGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.DeletePreparedStatementRequest
  ) extends zio.aws.athena.model.DeletePreparedStatementRequest.ReadOnly {
    override val statementName: StatementName =
      zio.aws.athena.model.primitives.StatementName(impl.statementName())
    override val workGroup: WorkGroupName =
      zio.aws.athena.model.primitives.WorkGroupName(impl.workGroup())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.DeletePreparedStatementRequest
  ): zio.aws.athena.model.DeletePreparedStatementRequest.ReadOnly = new Wrapper(
    impl
  )
}
