package zio.aws.athena
import zio.aws.athena.model.primitives.{
  QueryExecutionId,
  KeyString,
  ParametersMapValue,
  NamedQueryId,
  TagKey
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.athena.model.primitives.MaxTableMetadataCount.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AmazonResourceName extends Subtype[String]
    type AmazonResourceName =
      zio.aws.athena.model.primitives.AmazonResourceName.Type
    type BoxedBoolean = Boolean
    object BytesScannedCutoffValue extends Subtype[Long]
    type BytesScannedCutoffValue =
      zio.aws.athena.model.primitives.BytesScannedCutoffValue.Type
    object CatalogNameString extends Subtype[String]
    type CatalogNameString =
      zio.aws.athena.model.primitives.CatalogNameString.Type
    object CommentString extends Subtype[String]
    type CommentString = zio.aws.athena.model.primitives.CommentString.Type
    object DatabaseString extends Subtype[String]
    type DatabaseString = zio.aws.athena.model.primitives.DatabaseString.Type
    object Date extends Subtype[Instant]
    type Date = zio.aws.athena.model.primitives.Date.Type
    object DatumString extends Subtype[String]
    type DatumString = zio.aws.athena.model.primitives.DatumString.Type
    object DescriptionString extends Subtype[String]
    type DescriptionString =
      zio.aws.athena.model.primitives.DescriptionString.Type
    object ErrorCategory extends Subtype[Int]
    type ErrorCategory = zio.aws.athena.model.primitives.ErrorCategory.Type
    object ErrorCode extends Subtype[String]
    type ErrorCode = zio.aws.athena.model.primitives.ErrorCode.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.athena.model.primitives.ErrorMessage.Type
    object ErrorType extends Subtype[Int]
    type ErrorType = zio.aws.athena.model.primitives.ErrorType.Type
    object ExpressionString extends Subtype[String]
    type ExpressionString =
      zio.aws.athena.model.primitives.ExpressionString.Type
    object IdempotencyToken extends Subtype[String]
    type IdempotencyToken =
      zio.aws.athena.model.primitives.IdempotencyToken.Type
    type Integer = Int
    object KeyString extends Subtype[String]
    type KeyString = zio.aws.athena.model.primitives.KeyString.Type
    object MaxDataCatalogsCount extends Subtype[Int]
    type MaxDataCatalogsCount =
      zio.aws.athena.model.primitives.MaxDataCatalogsCount.Type
    object MaxDatabasesCount extends Subtype[Int]
    type MaxDatabasesCount =
      zio.aws.athena.model.primitives.MaxDatabasesCount.Type
    object MaxEngineVersionsCount extends Subtype[Int]
    type MaxEngineVersionsCount =
      zio.aws.athena.model.primitives.MaxEngineVersionsCount.Type
    object MaxNamedQueriesCount extends Subtype[Int]
    type MaxNamedQueriesCount =
      zio.aws.athena.model.primitives.MaxNamedQueriesCount.Type
    object MaxPreparedStatementsCount extends Subtype[Int]
    type MaxPreparedStatementsCount =
      zio.aws.athena.model.primitives.MaxPreparedStatementsCount.Type
    object MaxQueryExecutionsCount extends Subtype[Int]
    type MaxQueryExecutionsCount =
      zio.aws.athena.model.primitives.MaxQueryExecutionsCount.Type
    object MaxQueryResults extends Subtype[Int]
    type MaxQueryResults = zio.aws.athena.model.primitives.MaxQueryResults.Type
    object MaxTableMetadataCount extends Subtype[Int]
    type MaxTableMetadataCount =
      zio.aws.athena.model.primitives.MaxTableMetadataCount.Type
    object MaxTagsCount extends Subtype[Int]
    type MaxTagsCount = zio.aws.athena.model.primitives.MaxTagsCount.Type
    object MaxWorkGroupsCount extends Subtype[Int]
    type MaxWorkGroupsCount =
      zio.aws.athena.model.primitives.MaxWorkGroupsCount.Type
    object NameString extends Subtype[String]
    type NameString = zio.aws.athena.model.primitives.NameString.Type
    object NamedQueryDescriptionString extends Subtype[String]
    type NamedQueryDescriptionString =
      zio.aws.athena.model.primitives.NamedQueryDescriptionString.Type
    object NamedQueryId extends Subtype[String]
    type NamedQueryId = zio.aws.athena.model.primitives.NamedQueryId.Type
    object ParametersMapValue extends Subtype[String]
    type ParametersMapValue =
      zio.aws.athena.model.primitives.ParametersMapValue.Type
    object QueryExecutionId extends Subtype[String]
    type QueryExecutionId =
      zio.aws.athena.model.primitives.QueryExecutionId.Type
    object QueryString extends Subtype[String]
    type QueryString = zio.aws.athena.model.primitives.QueryString.Type
    object StatementName extends Subtype[String]
    type StatementName = zio.aws.athena.model.primitives.StatementName.Type
    object TableTypeString extends Subtype[String]
    type TableTypeString = zio.aws.athena.model.primitives.TableTypeString.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.athena.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.athena.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.athena.model.primitives.Timestamp.Type
    object Token extends Subtype[String]
    type Token = zio.aws.athena.model.primitives.Token.Type
    object TypeString extends Subtype[String]
    type TypeString = zio.aws.athena.model.primitives.TypeString.Type
    object WorkGroupDescriptionString extends Subtype[String]
    type WorkGroupDescriptionString =
      zio.aws.athena.model.primitives.WorkGroupDescriptionString.Type
    object WorkGroupName extends Subtype[String]
    type WorkGroupName = zio.aws.athena.model.primitives.WorkGroupName.Type
  }
  type ColumnInfoList = List[zio.aws.athena.model.ColumnInfo]
  type ColumnList = List[zio.aws.athena.model.Column]
  type DataCatalogSummaryList = List[zio.aws.athena.model.DataCatalogSummary]
  type DatabaseList = List[zio.aws.athena.model.Database]
  type DatumList = List[zio.aws.athena.model.Datum]
  type EngineVersionsList = List[zio.aws.athena.model.EngineVersion]
  type NamedQueryIdList = List[NamedQueryId]
  type NamedQueryList = List[zio.aws.athena.model.NamedQuery]
  type ParametersMap = Map[KeyString, ParametersMapValue]
  type PreparedStatementsList =
    List[zio.aws.athena.model.PreparedStatementSummary]
  type QueryExecutionIdList = List[QueryExecutionId]
  type QueryExecutionList = List[zio.aws.athena.model.QueryExecution]
  type RowList = List[zio.aws.athena.model.Row]
  type TableMetadataList = List[zio.aws.athena.model.TableMetadata]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.athena.model.Tag]
  type UnprocessedNamedQueryIdList =
    List[zio.aws.athena.model.UnprocessedNamedQueryId]
  type UnprocessedQueryExecutionIdList =
    List[zio.aws.athena.model.UnprocessedQueryExecutionId]
  type WorkGroupsList = List[zio.aws.athena.model.WorkGroupSummary]
}
