package zio.aws.athena.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.{MaxDataCatalogsCount, Token}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListDataCatalogsRequest(
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[MaxDataCatalogsCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest = {
    import ListDataCatalogsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxDataCatalogsCount.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListDataCatalogsRequest.ReadOnly =
    zio.aws.athena.model.ListDataCatalogsRequest.wrap(buildAwsValue())
}
object ListDataCatalogsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListDataCatalogsRequest =
      zio.aws.athena.model.ListDataCatalogsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[Token]
    def maxResults: Optional[MaxDataCatalogsCount]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxDataCatalogsCount] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest
  ) extends zio.aws.athena.model.ListDataCatalogsRequest.ReadOnly {
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
    override val maxResults: Optional[MaxDataCatalogsCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.athena.model.primitives.MaxDataCatalogsCount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest
  ): zio.aws.athena.model.ListDataCatalogsRequest.ReadOnly = new Wrapper(impl)
}
