package zio.aws.athena.model
import zio.aws.athena.model.primitives.CatalogNameString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetDataCatalogRequest(name: CatalogNameString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetDataCatalogRequest = {
    import GetDataCatalogRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetDataCatalogRequest
      .builder()
      .name(CatalogNameString.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.GetDataCatalogRequest.ReadOnly =
    zio.aws.athena.model.GetDataCatalogRequest.wrap(buildAwsValue())
}
object GetDataCatalogRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetDataCatalogRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetDataCatalogRequest =
      zio.aws.athena.model.GetDataCatalogRequest(name)
    def name: CatalogNameString
    def getName: ZIO[Any, Nothing, CatalogNameString] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetDataCatalogRequest
  ) extends zio.aws.athena.model.GetDataCatalogRequest.ReadOnly {
    override val name: CatalogNameString =
      zio.aws.athena.model.primitives.CatalogNameString(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetDataCatalogRequest
  ): zio.aws.athena.model.GetDataCatalogRequest.ReadOnly = new Wrapper(impl)
}
