package zio.aws.athena.model
import zio.aws.athena.model.primitives.Token
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListWorkGroupsResponse(
    workGroups: Optional[Iterable[zio.aws.athena.model.WorkGroupSummary]] =
      Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListWorkGroupsResponse = {
    import ListWorkGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListWorkGroupsResponse
      .builder()
      .optionallyWith(
        workGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.workGroups)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListWorkGroupsResponse.ReadOnly =
    zio.aws.athena.model.ListWorkGroupsResponse.wrap(buildAwsValue())
}
object ListWorkGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListWorkGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListWorkGroupsResponse =
      zio.aws.athena.model.ListWorkGroupsResponse(
        workGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def workGroups
        : Optional[List[zio.aws.athena.model.WorkGroupSummary.ReadOnly]]
    def nextToken: Optional[Token]
    def getWorkGroups: ZIO[Any, AwsError, List[
      zio.aws.athena.model.WorkGroupSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("workGroups", workGroups)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListWorkGroupsResponse
  ) extends zio.aws.athena.model.ListWorkGroupsResponse.ReadOnly {
    override val workGroups
        : Optional[List[zio.aws.athena.model.WorkGroupSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.athena.model.WorkGroupSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListWorkGroupsResponse
  ): zio.aws.athena.model.ListWorkGroupsResponse.ReadOnly = new Wrapper(impl)
}
