package zio.aws.athena.model
import zio.aws.athena.model.primitives.Token
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListPreparedStatementsResponse(
    preparedStatements: Optional[
      Iterable[zio.aws.athena.model.PreparedStatementSummary]
    ] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListPreparedStatementsResponse = {
    import ListPreparedStatementsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListPreparedStatementsResponse
      .builder()
      .optionallyWith(
        preparedStatements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.preparedStatements)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListPreparedStatementsResponse.ReadOnly =
    zio.aws.athena.model.ListPreparedStatementsResponse.wrap(buildAwsValue())
}
object ListPreparedStatementsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListPreparedStatementsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListPreparedStatementsResponse =
      zio.aws.athena.model.ListPreparedStatementsResponse(
        preparedStatements.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def preparedStatements
        : Optional[List[zio.aws.athena.model.PreparedStatementSummary.ReadOnly]]
    def nextToken: Optional[Token]
    def getPreparedStatements: ZIO[Any, AwsError, List[
      zio.aws.athena.model.PreparedStatementSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("preparedStatements", preparedStatements)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListPreparedStatementsResponse
  ) extends zio.aws.athena.model.ListPreparedStatementsResponse.ReadOnly {
    override val preparedStatements: Optional[
      List[zio.aws.athena.model.PreparedStatementSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.preparedStatements())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.athena.model.PreparedStatementSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListPreparedStatementsResponse
  ): zio.aws.athena.model.ListPreparedStatementsResponse.ReadOnly = new Wrapper(
    impl
  )
}
