package zio.aws.athena.model
import scala.jdk.CollectionConverters.*
sealed trait S3AclOption {
  def unwrap: software.amazon.awssdk.services.athena.model.S3AclOption
}
object S3AclOption {
  def wrap(
      value: software.amazon.awssdk.services.athena.model.S3AclOption
  ): zio.aws.athena.model.S3AclOption = value match {
    case software.amazon.awssdk.services.athena.model.S3AclOption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.athena.model.S3AclOption.BUCKET_OWNER_FULL_CONTROL =>
      val r = BUCKET_OWNER_FULL_CONTROL
      r
  }
  case object unknownToSdkVersion extends zio.aws.athena.model.S3AclOption {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.S3AclOption =
      software.amazon.awssdk.services.athena.model.S3AclOption.UNKNOWN_TO_SDK_VERSION
  }
  case object BUCKET_OWNER_FULL_CONTROL
      extends zio.aws.athena.model.S3AclOption {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.S3AclOption =
      software.amazon.awssdk.services.athena.model.S3AclOption.BUCKET_OWNER_FULL_CONTROL
  }
}
