package zio.aws.athena.model
import zio.aws.athena.model.primitives.BoxedBoolean
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResultConfigurationUpdates(
    outputLocation: Optional[String] = Optional.Absent,
    removeOutputLocation: Optional[BoxedBoolean] = Optional.Absent,
    encryptionConfiguration: Optional[
      zio.aws.athena.model.EncryptionConfiguration
    ] = Optional.Absent,
    removeEncryptionConfiguration: Optional[BoxedBoolean] = Optional.Absent,
    expectedBucketOwner: Optional[String] = Optional.Absent,
    removeExpectedBucketOwner: Optional[BoxedBoolean] = Optional.Absent,
    aclConfiguration: Optional[zio.aws.athena.model.AclConfiguration] =
      Optional.Absent,
    removeAclConfiguration: Optional[BoxedBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ResultConfigurationUpdates = {
    import ResultConfigurationUpdates.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ResultConfigurationUpdates
      .builder()
      .optionallyWith(outputLocation.map(value => value: java.lang.String))(
        _.outputLocation
      )
      .optionallyWith(
        removeOutputLocation.map(value => value: java.lang.Boolean)
      )(_.removeOutputLocation)
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .optionallyWith(
        removeEncryptionConfiguration.map(value => value: java.lang.Boolean)
      )(_.removeEncryptionConfiguration)
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .optionallyWith(
        removeExpectedBucketOwner.map(value => value: java.lang.Boolean)
      )(_.removeExpectedBucketOwner)
      .optionallyWith(aclConfiguration.map(value => value.buildAwsValue()))(
        _.aclConfiguration
      )
      .optionallyWith(
        removeAclConfiguration.map(value => value: java.lang.Boolean)
      )(_.removeAclConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ResultConfigurationUpdates.ReadOnly =
    zio.aws.athena.model.ResultConfigurationUpdates.wrap(buildAwsValue())
}
object ResultConfigurationUpdates {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ResultConfigurationUpdates
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ResultConfigurationUpdates =
      zio.aws.athena.model.ResultConfigurationUpdates(
        outputLocation.map(value => value),
        removeOutputLocation.map(value => value),
        encryptionConfiguration.map(value => value.asEditable),
        removeEncryptionConfiguration.map(value => value),
        expectedBucketOwner.map(value => value),
        removeExpectedBucketOwner.map(value => value),
        aclConfiguration.map(value => value.asEditable),
        removeAclConfiguration.map(value => value)
      )
    def outputLocation: Optional[String]
    def removeOutputLocation: Optional[BoxedBoolean]
    def encryptionConfiguration
        : Optional[zio.aws.athena.model.EncryptionConfiguration.ReadOnly]
    def removeEncryptionConfiguration: Optional[BoxedBoolean]
    def expectedBucketOwner: Optional[String]
    def removeExpectedBucketOwner: Optional[BoxedBoolean]
    def aclConfiguration
        : Optional[zio.aws.athena.model.AclConfiguration.ReadOnly]
    def removeAclConfiguration: Optional[BoxedBoolean]
    def getOutputLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outputLocation", outputLocation)
    def getRemoveOutputLocation: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("removeOutputLocation", removeOutputLocation)
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.EncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
    def getRemoveEncryptionConfiguration: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField(
        "removeEncryptionConfiguration",
        removeEncryptionConfiguration
      )
    def getExpectedBucketOwner: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
    def getRemoveExpectedBucketOwner: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField(
        "removeExpectedBucketOwner",
        removeExpectedBucketOwner
      )
    def getAclConfiguration
        : ZIO[Any, AwsError, zio.aws.athena.model.AclConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("aclConfiguration", aclConfiguration)
    def getRemoveAclConfiguration: ZIO[Any, AwsError, BoxedBoolean] = AwsError
      .unwrapOptionField("removeAclConfiguration", removeAclConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ResultConfigurationUpdates
  ) extends zio.aws.athena.model.ResultConfigurationUpdates.ReadOnly {
    override val outputLocation: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.outputLocation())
      .map(value => value: String)
    override val removeOutputLocation: Optional[BoxedBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeOutputLocation())
        .map(value => value: BoxedBoolean)
    override val encryptionConfiguration
        : Optional[zio.aws.athena.model.EncryptionConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionConfiguration())
        .map(value => zio.aws.athena.model.EncryptionConfiguration.wrap(value))
    override val removeEncryptionConfiguration: Optional[BoxedBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeEncryptionConfiguration())
        .map(value => value: BoxedBoolean)
    override val expectedBucketOwner: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.expectedBucketOwner())
      .map(value => value: String)
    override val removeExpectedBucketOwner: Optional[BoxedBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeExpectedBucketOwner())
        .map(value => value: BoxedBoolean)
    override val aclConfiguration
        : Optional[zio.aws.athena.model.AclConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aclConfiguration())
        .map(value => zio.aws.athena.model.AclConfiguration.wrap(value))
    override val removeAclConfiguration: Optional[BoxedBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeAclConfiguration())
        .map(value => value: BoxedBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ResultConfigurationUpdates
  ): zio.aws.athena.model.ResultConfigurationUpdates.ReadOnly = new Wrapper(
    impl
  )
}
