package zio.aws.athena.model
import zio.aws.athena.model.primitives.CatalogNameString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteDataCatalogRequest(name: CatalogNameString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.DeleteDataCatalogRequest = {
    import DeleteDataCatalogRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.DeleteDataCatalogRequest
      .builder()
      .name(CatalogNameString.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.DeleteDataCatalogRequest.ReadOnly =
    zio.aws.athena.model.DeleteDataCatalogRequest.wrap(buildAwsValue())
}
object DeleteDataCatalogRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.DeleteDataCatalogRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.DeleteDataCatalogRequest =
      zio.aws.athena.model.DeleteDataCatalogRequest(name)
    def name: CatalogNameString
    def getName: ZIO[Any, Nothing, CatalogNameString] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.DeleteDataCatalogRequest
  ) extends zio.aws.athena.model.DeleteDataCatalogRequest.ReadOnly {
    override val name: CatalogNameString =
      zio.aws.athena.model.primitives.CatalogNameString(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.DeleteDataCatalogRequest
  ): zio.aws.athena.model.DeleteDataCatalogRequest.ReadOnly = new Wrapper(impl)
}
