package zio.aws.athena.model
import zio.aws.athena.model.primitives.{
  DatabaseString,
  WorkGroupName,
  IdempotencyToken,
  NameString,
  DescriptionString,
  QueryString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateNamedQueryRequest(
    name: NameString,
    description: Optional[DescriptionString] = Optional.Absent,
    database: DatabaseString,
    queryString: QueryString,
    clientRequestToken: Optional[IdempotencyToken] = Optional.Absent,
    workGroup: Optional[WorkGroupName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.CreateNamedQueryRequest = {
    import CreateNamedQueryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.CreateNamedQueryRequest
      .builder()
      .name(NameString.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .database(DatabaseString.unwrap(database): java.lang.String)
      .queryString(QueryString.unwrap(queryString): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        workGroup.map(value => WorkGroupName.unwrap(value): java.lang.String)
      )(_.workGroup)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.CreateNamedQueryRequest.ReadOnly =
    zio.aws.athena.model.CreateNamedQueryRequest.wrap(buildAwsValue())
}
object CreateNamedQueryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.CreateNamedQueryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.CreateNamedQueryRequest =
      zio.aws.athena.model.CreateNamedQueryRequest(
        name,
        description.map(value => value),
        database,
        queryString,
        clientRequestToken.map(value => value),
        workGroup.map(value => value)
      )
    def name: NameString
    def description: Optional[DescriptionString]
    def database: DatabaseString
    def queryString: QueryString
    def clientRequestToken: Optional[IdempotencyToken]
    def workGroup: Optional[WorkGroupName]
    def getName: ZIO[Any, Nothing, NameString] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getDatabase: ZIO[Any, Nothing, DatabaseString] = ZIO.succeed(database)
    def getQueryString: ZIO[Any, Nothing, QueryString] =
      ZIO.succeed(queryString)
    def getClientRequestToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getWorkGroup: ZIO[Any, AwsError, WorkGroupName] =
      AwsError.unwrapOptionField("workGroup", workGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.CreateNamedQueryRequest
  ) extends zio.aws.athena.model.CreateNamedQueryRequest.ReadOnly {
    override val name: NameString =
      zio.aws.athena.model.primitives.NameString(impl.name())
    override val description: Optional[DescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.athena.model.primitives.DescriptionString(value))
    override val database: DatabaseString =
      zio.aws.athena.model.primitives.DatabaseString(impl.database())
    override val queryString: QueryString =
      zio.aws.athena.model.primitives.QueryString(impl.queryString())
    override val clientRequestToken: Optional[IdempotencyToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.athena.model.primitives.IdempotencyToken(value))
    override val workGroup: Optional[WorkGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.workGroup())
      .map(value => zio.aws.athena.model.primitives.WorkGroupName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.CreateNamedQueryRequest
  ): zio.aws.athena.model.CreateNamedQueryRequest.ReadOnly = new Wrapper(impl)
}
