package zio.aws.athena.model
import zio.aws.athena.model.primitives.NamedQueryId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchGetNamedQueryRequest(
    namedQueryIds: Iterable[NamedQueryId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.BatchGetNamedQueryRequest = {
    import BatchGetNamedQueryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.BatchGetNamedQueryRequest
      .builder()
      .namedQueryIds(namedQueryIds.map { item =>
        NamedQueryId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.BatchGetNamedQueryRequest.ReadOnly =
    zio.aws.athena.model.BatchGetNamedQueryRequest.wrap(buildAwsValue())
}
object BatchGetNamedQueryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.BatchGetNamedQueryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.BatchGetNamedQueryRequest =
      zio.aws.athena.model.BatchGetNamedQueryRequest(namedQueryIds)
    def namedQueryIds: List[NamedQueryId]
    def getNamedQueryIds: ZIO[Any, Nothing, List[NamedQueryId]] =
      ZIO.succeed(namedQueryIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.BatchGetNamedQueryRequest
  ) extends zio.aws.athena.model.BatchGetNamedQueryRequest.ReadOnly {
    override val namedQueryIds: List[NamedQueryId] = impl
      .namedQueryIds()
      .asScala
      .map { item =>
        zio.aws.athena.model.primitives.NamedQueryId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.BatchGetNamedQueryRequest
  ): zio.aws.athena.model.BatchGetNamedQueryRequest.ReadOnly = new Wrapper(impl)
}
