package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EncryptionConfiguration(
    encryptionOption: zio.aws.athena.model.EncryptionOption,
    kmsKey: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.EncryptionConfiguration = {
    import EncryptionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.EncryptionConfiguration
      .builder()
      .encryptionOption(encryptionOption.unwrap)
      .optionallyWith(kmsKey.map(value => value: java.lang.String))(_.kmsKey)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.EncryptionConfiguration.ReadOnly =
    zio.aws.athena.model.EncryptionConfiguration.wrap(buildAwsValue())
}
object EncryptionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.EncryptionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.EncryptionConfiguration =
      zio.aws.athena.model
        .EncryptionConfiguration(encryptionOption, kmsKey.map(value => value))
    def encryptionOption: zio.aws.athena.model.EncryptionOption
    def kmsKey: Optional[String]
    def getEncryptionOption
        : ZIO[Any, Nothing, zio.aws.athena.model.EncryptionOption] =
      ZIO.succeed(encryptionOption)
    def getKmsKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKey", kmsKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.EncryptionConfiguration
  ) extends zio.aws.athena.model.EncryptionConfiguration.ReadOnly {
    override val encryptionOption: zio.aws.athena.model.EncryptionOption =
      zio.aws.athena.model.EncryptionOption.wrap(impl.encryptionOption())
    override val kmsKey: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKey())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.EncryptionConfiguration
  ): zio.aws.athena.model.EncryptionConfiguration.ReadOnly = new Wrapper(impl)
}
