package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetDataCatalogResponse(
    dataCatalog: Optional[zio.aws.athena.model.DataCatalog] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetDataCatalogResponse = {
    import GetDataCatalogResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetDataCatalogResponse
      .builder()
      .optionallyWith(dataCatalog.map(value => value.buildAwsValue()))(
        _.dataCatalog
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.GetDataCatalogResponse.ReadOnly =
    zio.aws.athena.model.GetDataCatalogResponse.wrap(buildAwsValue())
}
object GetDataCatalogResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetDataCatalogResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetDataCatalogResponse =
      zio.aws.athena.model
        .GetDataCatalogResponse(dataCatalog.map(value => value.asEditable))
    def dataCatalog: Optional[zio.aws.athena.model.DataCatalog.ReadOnly]
    def getDataCatalog
        : ZIO[Any, AwsError, zio.aws.athena.model.DataCatalog.ReadOnly] =
      AwsError.unwrapOptionField("dataCatalog", dataCatalog)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetDataCatalogResponse
  ) extends zio.aws.athena.model.GetDataCatalogResponse.ReadOnly {
    override val dataCatalog
        : Optional[zio.aws.athena.model.DataCatalog.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataCatalog())
        .map(value => zio.aws.athena.model.DataCatalog.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetDataCatalogResponse
  ): zio.aws.athena.model.GetDataCatalogResponse.ReadOnly = new Wrapper(impl)
}
