package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Row(
    data: Optional[Iterable[zio.aws.athena.model.Datum]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.athena.model.Row = {
    import Row.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.Row
      .builder()
      .optionallyWith(
        data.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.data)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.Row.ReadOnly =
    zio.aws.athena.model.Row.wrap(buildAwsValue())
}
object Row {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.athena.model.Row] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.Row = zio.aws.athena.model.Row(
      data.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def data: Optional[List[zio.aws.athena.model.Datum.ReadOnly]]
    def getData: ZIO[Any, AwsError, List[zio.aws.athena.model.Datum.ReadOnly]] =
      AwsError.unwrapOptionField("data", data)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.Row
  ) extends zio.aws.athena.model.Row.ReadOnly {
    override val data: Optional[List[zio.aws.athena.model.Datum.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.data())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.athena.model.Datum.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.Row
  ): zio.aws.athena.model.Row.ReadOnly = new Wrapper(impl)
}
