package zio.aws.athena.model
import zio.aws.athena.model.primitives.Token
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceResponse(
    tags: Optional[Iterable[zio.aws.athena.model.Tag]] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.athena.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListTagsForResourceResponse =
      zio.aws.athena.model.ListTagsForResourceResponse(
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def tags: Optional[List[zio.aws.athena.model.Tag.ReadOnly]]
    def nextToken: Optional[Token]
    def getTags: ZIO[Any, AwsError, List[zio.aws.athena.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListTagsForResourceResponse
  ) extends zio.aws.athena.model.ListTagsForResourceResponse.ReadOnly {
    override val tags: Optional[List[zio.aws.athena.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.athena.model.Tag.wrap(item)
          }.toList
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListTagsForResourceResponse
  ): zio.aws.athena.model.ListTagsForResourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
