package zio.aws.athena.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.{
  WorkGroupName,
  MaxQueryExecutionsCount,
  Token
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListQueryExecutionsRequest(
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[MaxQueryExecutionsCount] = Optional.Absent,
    workGroup: Optional[WorkGroupName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest = {
    import ListQueryExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxQueryExecutionsCount.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        workGroup.map(value => WorkGroupName.unwrap(value): java.lang.String)
      )(_.workGroup)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListQueryExecutionsRequest.ReadOnly =
    zio.aws.athena.model.ListQueryExecutionsRequest.wrap(buildAwsValue())
}
object ListQueryExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListQueryExecutionsRequest =
      zio.aws.athena.model.ListQueryExecutionsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        workGroup.map(value => value)
      )
    def nextToken: Optional[Token]
    def maxResults: Optional[MaxQueryExecutionsCount]
    def workGroup: Optional[WorkGroupName]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxQueryExecutionsCount] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getWorkGroup: ZIO[Any, AwsError, WorkGroupName] =
      AwsError.unwrapOptionField("workGroup", workGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest
  ) extends zio.aws.athena.model.ListQueryExecutionsRequest.ReadOnly {
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
    override val maxResults: Optional[MaxQueryExecutionsCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.athena.model.primitives.MaxQueryExecutionsCount(value)
        )
    override val workGroup: Optional[WorkGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.workGroup())
      .map(value => zio.aws.athena.model.primitives.WorkGroupName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest
  ): zio.aws.athena.model.ListQueryExecutionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
