package zio.aws.athena.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.{
  MaxQueryResults,
  Token,
  QueryExecutionId
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetQueryResultsRequest(
    queryExecutionId: QueryExecutionId,
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[MaxQueryResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetQueryResultsRequest = {
    import GetQueryResultsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetQueryResultsRequest
      .builder()
      .queryExecutionId(
        QueryExecutionId.unwrap(queryExecutionId): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxQueryResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.GetQueryResultsRequest.ReadOnly =
    zio.aws.athena.model.GetQueryResultsRequest.wrap(buildAwsValue())
}
object GetQueryResultsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetQueryResultsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetQueryResultsRequest =
      zio.aws.athena.model.GetQueryResultsRequest(
        queryExecutionId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def queryExecutionId: QueryExecutionId
    def nextToken: Optional[Token]
    def maxResults: Optional[MaxQueryResults]
    def getQueryExecutionId: ZIO[Any, Nothing, QueryExecutionId] =
      ZIO.succeed(queryExecutionId)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxQueryResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetQueryResultsRequest
  ) extends zio.aws.athena.model.GetQueryResultsRequest.ReadOnly {
    override val queryExecutionId: QueryExecutionId =
      zio.aws.athena.model.primitives.QueryExecutionId(impl.queryExecutionId())
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
    override val maxResults: Optional[MaxQueryResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.athena.model.primitives.MaxQueryResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetQueryResultsRequest
  ): zio.aws.athena.model.GetQueryResultsRequest.ReadOnly = new Wrapper(impl)
}
