package zio.aws.athena.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.{ErrorType, ErrorCategory}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class AthenaError(
    errorCategory: Optional[ErrorCategory] = Optional.Absent,
    errorType: Optional[ErrorType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.AthenaError = {
    import AthenaError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.AthenaError
      .builder()
      .optionallyWith(
        errorCategory.map(value => ErrorCategory.unwrap(value): Integer)
      )(_.errorCategory)
      .optionallyWith(errorType.map(value => ErrorType.unwrap(value): Integer))(
        _.errorType
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.AthenaError.ReadOnly =
    zio.aws.athena.model.AthenaError.wrap(buildAwsValue())
}
object AthenaError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.AthenaError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.AthenaError =
      zio.aws.athena.model.AthenaError(
        errorCategory.map(value => value),
        errorType.map(value => value)
      )
    def errorCategory: Optional[ErrorCategory]
    def errorType: Optional[ErrorType]
    def getErrorCategory: ZIO[Any, AwsError, ErrorCategory] =
      AwsError.unwrapOptionField("errorCategory", errorCategory)
    def getErrorType: ZIO[Any, AwsError, ErrorType] =
      AwsError.unwrapOptionField("errorType", errorType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.AthenaError
  ) extends zio.aws.athena.model.AthenaError.ReadOnly {
    override val errorCategory: Optional[ErrorCategory] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCategory())
      .map(value => zio.aws.athena.model.primitives.ErrorCategory(value))
    override val errorType: Optional[ErrorType] = zio.aws.core.internal
      .optionalFromNullable(impl.errorType())
      .map(value => zio.aws.athena.model.primitives.ErrorType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.AthenaError
  ): zio.aws.athena.model.AthenaError.ReadOnly = new Wrapper(impl)
}
