package zio.aws.athena
import zio.aws.athena.model.GetQueryExecutionResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.athena.model.{
  CreateWorkGroupRequest,
  GetDataCatalogRequest,
  GetWorkGroupRequest,
  ListWorkGroupsRequest,
  GetNamedQueryRequest,
  DeleteDataCatalogRequest,
  ListTagsForResourceRequest,
  GetDatabaseRequest,
  CreatePreparedStatementRequest,
  DeleteWorkGroupRequest,
  DeletePreparedStatementRequest,
  ListDatabasesRequest,
  ListDataCatalogsRequest,
  GetPreparedStatementRequest,
  ListQueryExecutionsRequest,
  ListPreparedStatementsRequest,
  UpdateWorkGroupRequest,
  BatchGetQueryExecutionRequest,
  StartQueryExecutionRequest,
  ListTableMetadataRequest,
  CreateNamedQueryRequest,
  ListEngineVersionsRequest,
  CreateDataCatalogRequest,
  UntagResourceRequest,
  GetQueryResultsRequest,
  GetTableMetadataRequest,
  UpdateDataCatalogRequest,
  DeleteNamedQueryRequest,
  UpdateNamedQueryRequest,
  UpdatePreparedStatementRequest,
  ListNamedQueriesRequest,
  GetQueryExecutionRequest,
  StopQueryExecutionRequest,
  BatchGetNamedQueryRequest,
  TagResourceRequest
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.athena.{
  AthenaAsyncClientBuilder,
  AthenaAsyncClient
}
import zio.aws.athena.model.primitives.{NamedQueryId, QueryExecutionId}
import zio.stream.ZStream
import software.amazon.awssdk.services.athena.model.{
  ListQueryExecutionsResponse,
  UpdateNamedQueryResponse,
  GetWorkGroupResponse,
  CreateWorkGroupResponse,
  UpdateWorkGroupResponse,
  WorkGroupSummary,
  CreateNamedQueryResponse,
  GetTableMetadataResponse,
  CreateDataCatalogResponse,
  PreparedStatementSummary,
  GetDatabaseResponse,
  ListDatabasesResponse,
  GetPreparedStatementResponse,
  Tag,
  TableMetadata,
  ListPreparedStatementsResponse,
  CreatePreparedStatementResponse,
  EngineVersion,
  GetQueryResultsResponse,
  ListTagsForResourceResponse,
  UpdateDataCatalogResponse,
  UntagResourceResponse,
  DeletePreparedStatementResponse,
  DeleteNamedQueryResponse,
  StopQueryExecutionResponse,
  BatchGetQueryExecutionResponse,
  UpdatePreparedStatementResponse,
  DataCatalogSummary,
  GetNamedQueryResponse,
  GetDataCatalogResponse,
  ListWorkGroupsResponse,
  Database,
  ListNamedQueriesResponse,
  ListTableMetadataResponse,
  DeleteWorkGroupResponse,
  ListEngineVersionsResponse,
  GetQueryExecutionResponse,
  BatchGetNamedQueryResponse,
  DeleteDataCatalogResponse,
  TagResourceResponse,
  ListDataCatalogsResponse,
  StartQueryExecutionResponse,
  Row
}
import scala.jdk.CollectionConverters.*
trait Athena extends AspectSupport[Athena] {
  val api: AthenaAsyncClient
  def listDatabases(
      request: ListDatabasesRequest
  ): ZStream[Any, AwsError, zio.aws.athena.model.Database.ReadOnly]
  def listDatabasesPaginated(
      request: ListDatabasesRequest
  ): IO[AwsError, zio.aws.athena.model.ListDatabasesResponse.ReadOnly]
  def updateDataCatalog(
      request: UpdateDataCatalogRequest
  ): IO[AwsError, zio.aws.athena.model.UpdateDataCatalogResponse.ReadOnly]
  def updateWorkGroup(
      request: UpdateWorkGroupRequest
  ): IO[AwsError, zio.aws.athena.model.UpdateWorkGroupResponse.ReadOnly]
  def getPreparedStatement(
      request: GetPreparedStatementRequest
  ): IO[AwsError, zio.aws.athena.model.GetPreparedStatementResponse.ReadOnly]
  def listQueryExecutions(
      request: ListQueryExecutionsRequest
  ): ZStream[Any, AwsError, QueryExecutionId]
  def listQueryExecutionsPaginated(
      request: ListQueryExecutionsRequest
  ): IO[AwsError, zio.aws.athena.model.ListQueryExecutionsResponse.ReadOnly]
  def listDataCatalogs(
      request: ListDataCatalogsRequest
  ): ZStream[Any, AwsError, zio.aws.athena.model.DataCatalogSummary.ReadOnly]
  def listDataCatalogsPaginated(
      request: ListDataCatalogsRequest
  ): IO[AwsError, zio.aws.athena.model.ListDataCatalogsResponse.ReadOnly]
  def getNamedQuery(
      request: GetNamedQueryRequest
  ): IO[AwsError, zio.aws.athena.model.GetNamedQueryResponse.ReadOnly]
  def updateNamedQuery(
      request: UpdateNamedQueryRequest
  ): IO[AwsError, zio.aws.athena.model.UpdateNamedQueryResponse.ReadOnly]
  def deletePreparedStatement(
      request: DeletePreparedStatementRequest
  ): IO[AwsError, zio.aws.athena.model.DeletePreparedStatementResponse.ReadOnly]
  def listEngineVersions(
      request: ListEngineVersionsRequest
  ): ZStream[Any, AwsError, zio.aws.athena.model.EngineVersion.ReadOnly]
  def listEngineVersionsPaginated(
      request: ListEngineVersionsRequest
  ): IO[AwsError, zio.aws.athena.model.ListEngineVersionsResponse.ReadOnly]
  def deleteNamedQuery(
      request: DeleteNamedQueryRequest
  ): IO[AwsError, zio.aws.athena.model.DeleteNamedQueryResponse.ReadOnly]
  def getTableMetadata(
      request: GetTableMetadataRequest
  ): IO[AwsError, zio.aws.athena.model.GetTableMetadataResponse.ReadOnly]
  def batchGetNamedQuery(
      request: BatchGetNamedQueryRequest
  ): IO[AwsError, zio.aws.athena.model.BatchGetNamedQueryResponse.ReadOnly]
  def createNamedQuery(
      request: CreateNamedQueryRequest
  ): IO[AwsError, zio.aws.athena.model.CreateNamedQueryResponse.ReadOnly]
  def getDataCatalog(
      request: GetDataCatalogRequest
  ): IO[AwsError, zio.aws.athena.model.GetDataCatalogResponse.ReadOnly]
  def listWorkGroups(
      request: ListWorkGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.athena.model.WorkGroupSummary.ReadOnly]
  def listWorkGroupsPaginated(
      request: ListWorkGroupsRequest
  ): IO[AwsError, zio.aws.athena.model.ListWorkGroupsResponse.ReadOnly]
  def listPreparedStatements(request: ListPreparedStatementsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.athena.model.PreparedStatementSummary.ReadOnly
  ]
  def listPreparedStatementsPaginated(
      request: ListPreparedStatementsRequest
  ): IO[AwsError, zio.aws.athena.model.ListPreparedStatementsResponse.ReadOnly]
  def createPreparedStatement(
      request: CreatePreparedStatementRequest
  ): IO[AwsError, zio.aws.athena.model.CreatePreparedStatementResponse.ReadOnly]
  def deleteDataCatalog(
      request: DeleteDataCatalogRequest
  ): IO[AwsError, zio.aws.athena.model.DeleteDataCatalogResponse.ReadOnly]
  def getQueryExecution(
      request: GetQueryExecutionRequest
  ): IO[AwsError, ReadOnly]
  def updatePreparedStatement(
      request: UpdatePreparedStatementRequest
  ): IO[AwsError, zio.aws.athena.model.UpdatePreparedStatementResponse.ReadOnly]
  def createDataCatalog(
      request: CreateDataCatalogRequest
  ): IO[AwsError, zio.aws.athena.model.CreateDataCatalogResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.athena.model.UntagResourceResponse.ReadOnly]
  def listTableMetadata(
      request: ListTableMetadataRequest
  ): ZStream[Any, AwsError, zio.aws.athena.model.TableMetadata.ReadOnly]
  def listTableMetadataPaginated(
      request: ListTableMetadataRequest
  ): IO[AwsError, zio.aws.athena.model.ListTableMetadataResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): ZStream[Any, AwsError, zio.aws.athena.model.Tag.ReadOnly]
  def listTagsForResourcePaginated(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.athena.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.athena.model.TagResourceResponse.ReadOnly]
  def listNamedQueries(
      request: ListNamedQueriesRequest
  ): ZStream[Any, AwsError, NamedQueryId]
  def listNamedQueriesPaginated(
      request: ListNamedQueriesRequest
  ): IO[AwsError, zio.aws.athena.model.ListNamedQueriesResponse.ReadOnly]
  def deleteWorkGroup(
      request: DeleteWorkGroupRequest
  ): IO[AwsError, zio.aws.athena.model.DeleteWorkGroupResponse.ReadOnly]
  def getDatabase(
      request: GetDatabaseRequest
  ): IO[AwsError, zio.aws.athena.model.GetDatabaseResponse.ReadOnly]
  def createWorkGroup(
      request: CreateWorkGroupRequest
  ): IO[AwsError, zio.aws.athena.model.CreateWorkGroupResponse.ReadOnly]
  def getWorkGroup(
      request: GetWorkGroupRequest
  ): IO[AwsError, zio.aws.athena.model.GetWorkGroupResponse.ReadOnly]
  def batchGetQueryExecution(
      request: BatchGetQueryExecutionRequest
  ): IO[AwsError, zio.aws.athena.model.BatchGetQueryExecutionResponse.ReadOnly]
  def startQueryExecution(
      request: StartQueryExecutionRequest
  ): IO[AwsError, zio.aws.athena.model.StartQueryExecutionResponse.ReadOnly]
  def getQueryResults(
      request: GetQueryResultsRequest
  ): IO[AwsError, StreamingOutputResult[
    Any,
    zio.aws.athena.model.ResultSetMetadata.ReadOnly,
    zio.aws.athena.model.Row.ReadOnly
  ]]
  def getQueryResultsPaginated(
      request: GetQueryResultsRequest
  ): IO[AwsError, zio.aws.athena.model.GetQueryResultsResponse.ReadOnly]
  def stopQueryExecution(
      request: StopQueryExecutionRequest
  ): IO[AwsError, zio.aws.athena.model.StopQueryExecutionResponse.ReadOnly]
}
object Athena {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Athena] = customized(
    identity
  )
  def customized(
      customization: AthenaAsyncClientBuilder => AthenaAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Athena] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: AthenaAsyncClientBuilder => AthenaAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Athena] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = AthenaAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[AthenaAsyncClient, AthenaAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[AthenaAsyncClient, AthenaAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new AthenaImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class AthenaImpl[R](
      override val api: AthenaAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Athena
      with AwsServiceBase[R] {
    override val serviceName: String = "Athena"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): AthenaImpl[R1] = new AthenaImpl(api, newAspect, r)
    def listDatabases(
        request: ListDatabasesRequest
    ): ZStream[Any, AwsError, zio.aws.athena.model.Database.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.athena.model.ListDatabasesRequest,
        ListDatabasesResponse,
        Database
      ](
        "listDatabases",
        api.listDatabases,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.databaseList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.athena.model.Database.wrap(item))
        .provideEnvironment(r)
    def listDatabasesPaginated(
        request: ListDatabasesRequest
    ): IO[AwsError, zio.aws.athena.model.ListDatabasesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.ListDatabasesRequest,
        ListDatabasesResponse
      ]("listDatabases", api.listDatabases)(request.buildAwsValue())
        .map(zio.aws.athena.model.ListDatabasesResponse.wrap)
        .provideEnvironment(r)
    def updateDataCatalog(
        request: UpdateDataCatalogRequest
    ): IO[AwsError, zio.aws.athena.model.UpdateDataCatalogResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.UpdateDataCatalogRequest,
        UpdateDataCatalogResponse
      ]("updateDataCatalog", api.updateDataCatalog)(request.buildAwsValue())
        .map(zio.aws.athena.model.UpdateDataCatalogResponse.wrap)
        .provideEnvironment(r)
    def updateWorkGroup(
        request: UpdateWorkGroupRequest
    ): IO[AwsError, zio.aws.athena.model.UpdateWorkGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.UpdateWorkGroupRequest,
        UpdateWorkGroupResponse
      ]("updateWorkGroup", api.updateWorkGroup)(request.buildAwsValue())
        .map(zio.aws.athena.model.UpdateWorkGroupResponse.wrap)
        .provideEnvironment(r)
    def getPreparedStatement(request: GetPreparedStatementRequest): IO[
      AwsError,
      zio.aws.athena.model.GetPreparedStatementResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.GetPreparedStatementRequest,
      GetPreparedStatementResponse
    ]("getPreparedStatement", api.getPreparedStatement)(request.buildAwsValue())
      .map(zio.aws.athena.model.GetPreparedStatementResponse.wrap)
      .provideEnvironment(r)
    def listQueryExecutions(
        request: ListQueryExecutionsRequest
    ): ZStream[Any, AwsError, QueryExecutionId] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest,
      ListQueryExecutionsResponse,
      java.lang.String
    ](
      "listQueryExecutions",
      api.listQueryExecutions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.queryExecutionIds().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.athena.model.primitives.QueryExecutionId(item))
      .provideEnvironment(r)
    def listQueryExecutionsPaginated(
        request: ListQueryExecutionsRequest
    ): IO[AwsError, zio.aws.athena.model.ListQueryExecutionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest,
        ListQueryExecutionsResponse
      ]("listQueryExecutions", api.listQueryExecutions)(request.buildAwsValue())
        .map(zio.aws.athena.model.ListQueryExecutionsResponse.wrap)
        .provideEnvironment(r)
    def listDataCatalogs(request: ListDataCatalogsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.athena.model.DataCatalogSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest,
      ListDataCatalogsResponse,
      DataCatalogSummary
    ](
      "listDataCatalogs",
      api.listDataCatalogs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.dataCatalogsSummary().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.athena.model.DataCatalogSummary.wrap(item))
      .provideEnvironment(r)
    def listDataCatalogsPaginated(
        request: ListDataCatalogsRequest
    ): IO[AwsError, zio.aws.athena.model.ListDataCatalogsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest,
        ListDataCatalogsResponse
      ]("listDataCatalogs", api.listDataCatalogs)(request.buildAwsValue())
        .map(zio.aws.athena.model.ListDataCatalogsResponse.wrap)
        .provideEnvironment(r)
    def getNamedQuery(
        request: GetNamedQueryRequest
    ): IO[AwsError, zio.aws.athena.model.GetNamedQueryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.GetNamedQueryRequest,
        GetNamedQueryResponse
      ]("getNamedQuery", api.getNamedQuery)(request.buildAwsValue())
        .map(zio.aws.athena.model.GetNamedQueryResponse.wrap)
        .provideEnvironment(r)
    def updateNamedQuery(
        request: UpdateNamedQueryRequest
    ): IO[AwsError, zio.aws.athena.model.UpdateNamedQueryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.UpdateNamedQueryRequest,
        UpdateNamedQueryResponse
      ]("updateNamedQuery", api.updateNamedQuery)(request.buildAwsValue())
        .map(zio.aws.athena.model.UpdateNamedQueryResponse.wrap)
        .provideEnvironment(r)
    def deletePreparedStatement(request: DeletePreparedStatementRequest): IO[
      AwsError,
      zio.aws.athena.model.DeletePreparedStatementResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.DeletePreparedStatementRequest,
      DeletePreparedStatementResponse
    ]("deletePreparedStatement", api.deletePreparedStatement)(
      request.buildAwsValue()
    ).map(zio.aws.athena.model.DeletePreparedStatementResponse.wrap)
      .provideEnvironment(r)
    def listEngineVersions(
        request: ListEngineVersionsRequest
    ): ZStream[Any, AwsError, zio.aws.athena.model.EngineVersion.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.athena.model.ListEngineVersionsRequest,
        ListEngineVersionsResponse,
        EngineVersion
      ](
        "listEngineVersions",
        api.listEngineVersions,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.engineVersions().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.athena.model.EngineVersion.wrap(item))
        .provideEnvironment(r)
    def listEngineVersionsPaginated(
        request: ListEngineVersionsRequest
    ): IO[AwsError, zio.aws.athena.model.ListEngineVersionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.ListEngineVersionsRequest,
        ListEngineVersionsResponse
      ]("listEngineVersions", api.listEngineVersions)(request.buildAwsValue())
        .map(zio.aws.athena.model.ListEngineVersionsResponse.wrap)
        .provideEnvironment(r)
    def deleteNamedQuery(
        request: DeleteNamedQueryRequest
    ): IO[AwsError, zio.aws.athena.model.DeleteNamedQueryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.DeleteNamedQueryRequest,
        DeleteNamedQueryResponse
      ]("deleteNamedQuery", api.deleteNamedQuery)(request.buildAwsValue())
        .map(zio.aws.athena.model.DeleteNamedQueryResponse.wrap)
        .provideEnvironment(r)
    def getTableMetadata(
        request: GetTableMetadataRequest
    ): IO[AwsError, zio.aws.athena.model.GetTableMetadataResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.GetTableMetadataRequest,
        GetTableMetadataResponse
      ]("getTableMetadata", api.getTableMetadata)(request.buildAwsValue())
        .map(zio.aws.athena.model.GetTableMetadataResponse.wrap)
        .provideEnvironment(r)
    def batchGetNamedQuery(
        request: BatchGetNamedQueryRequest
    ): IO[AwsError, zio.aws.athena.model.BatchGetNamedQueryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.BatchGetNamedQueryRequest,
        BatchGetNamedQueryResponse
      ]("batchGetNamedQuery", api.batchGetNamedQuery)(request.buildAwsValue())
        .map(zio.aws.athena.model.BatchGetNamedQueryResponse.wrap)
        .provideEnvironment(r)
    def createNamedQuery(
        request: CreateNamedQueryRequest
    ): IO[AwsError, zio.aws.athena.model.CreateNamedQueryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.CreateNamedQueryRequest,
        CreateNamedQueryResponse
      ]("createNamedQuery", api.createNamedQuery)(request.buildAwsValue())
        .map(zio.aws.athena.model.CreateNamedQueryResponse.wrap)
        .provideEnvironment(r)
    def getDataCatalog(
        request: GetDataCatalogRequest
    ): IO[AwsError, zio.aws.athena.model.GetDataCatalogResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.GetDataCatalogRequest,
        GetDataCatalogResponse
      ]("getDataCatalog", api.getDataCatalog)(request.buildAwsValue())
        .map(zio.aws.athena.model.GetDataCatalogResponse.wrap)
        .provideEnvironment(r)
    def listWorkGroups(
        request: ListWorkGroupsRequest
    ): ZStream[Any, AwsError, zio.aws.athena.model.WorkGroupSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest,
        ListWorkGroupsResponse,
        WorkGroupSummary
      ](
        "listWorkGroups",
        api.listWorkGroups,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.workGroups().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.athena.model.WorkGroupSummary.wrap(item))
        .provideEnvironment(r)
    def listWorkGroupsPaginated(
        request: ListWorkGroupsRequest
    ): IO[AwsError, zio.aws.athena.model.ListWorkGroupsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest,
        ListWorkGroupsResponse
      ]("listWorkGroups", api.listWorkGroups)(request.buildAwsValue())
        .map(zio.aws.athena.model.ListWorkGroupsResponse.wrap)
        .provideEnvironment(r)
    def listPreparedStatements(request: ListPreparedStatementsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.athena.model.PreparedStatementSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.athena.model.ListPreparedStatementsRequest,
      ListPreparedStatementsResponse,
      PreparedStatementSummary
    ](
      "listPreparedStatements",
      api.listPreparedStatements,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.preparedStatements().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.athena.model.PreparedStatementSummary.wrap(item))
      .provideEnvironment(r)
    def listPreparedStatementsPaginated(
        request: ListPreparedStatementsRequest
    ): IO[
      AwsError,
      zio.aws.athena.model.ListPreparedStatementsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.ListPreparedStatementsRequest,
      ListPreparedStatementsResponse
    ]("listPreparedStatements", api.listPreparedStatements)(
      request.buildAwsValue()
    ).map(zio.aws.athena.model.ListPreparedStatementsResponse.wrap)
      .provideEnvironment(r)
    def createPreparedStatement(request: CreatePreparedStatementRequest): IO[
      AwsError,
      zio.aws.athena.model.CreatePreparedStatementResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.CreatePreparedStatementRequest,
      CreatePreparedStatementResponse
    ]("createPreparedStatement", api.createPreparedStatement)(
      request.buildAwsValue()
    ).map(zio.aws.athena.model.CreatePreparedStatementResponse.wrap)
      .provideEnvironment(r)
    def deleteDataCatalog(
        request: DeleteDataCatalogRequest
    ): IO[AwsError, zio.aws.athena.model.DeleteDataCatalogResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.DeleteDataCatalogRequest,
        DeleteDataCatalogResponse
      ]("deleteDataCatalog", api.deleteDataCatalog)(request.buildAwsValue())
        .map(zio.aws.athena.model.DeleteDataCatalogResponse.wrap)
        .provideEnvironment(r)
    def getQueryExecution(
        request: GetQueryExecutionRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.GetQueryExecutionRequest,
      GetQueryExecutionResponse
    ]("getQueryExecution", api.getQueryExecution)(request.buildAwsValue())
      .map(zio.aws.athena.model.GetQueryExecutionResponse.wrap)
      .provideEnvironment(r)
    def updatePreparedStatement(request: UpdatePreparedStatementRequest): IO[
      AwsError,
      zio.aws.athena.model.UpdatePreparedStatementResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.UpdatePreparedStatementRequest,
      UpdatePreparedStatementResponse
    ]("updatePreparedStatement", api.updatePreparedStatement)(
      request.buildAwsValue()
    ).map(zio.aws.athena.model.UpdatePreparedStatementResponse.wrap)
      .provideEnvironment(r)
    def createDataCatalog(
        request: CreateDataCatalogRequest
    ): IO[AwsError, zio.aws.athena.model.CreateDataCatalogResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.CreateDataCatalogRequest,
        CreateDataCatalogResponse
      ]("createDataCatalog", api.createDataCatalog)(request.buildAwsValue())
        .map(zio.aws.athena.model.CreateDataCatalogResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.athena.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.athena.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def listTableMetadata(
        request: ListTableMetadataRequest
    ): ZStream[Any, AwsError, zio.aws.athena.model.TableMetadata.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.athena.model.ListTableMetadataRequest,
        ListTableMetadataResponse,
        TableMetadata
      ](
        "listTableMetadata",
        api.listTableMetadata,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.tableMetadataList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.athena.model.TableMetadata.wrap(item))
        .provideEnvironment(r)
    def listTableMetadataPaginated(
        request: ListTableMetadataRequest
    ): IO[AwsError, zio.aws.athena.model.ListTableMetadataResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.ListTableMetadataRequest,
        ListTableMetadataResponse
      ]("listTableMetadata", api.listTableMetadata)(request.buildAwsValue())
        .map(zio.aws.athena.model.ListTableMetadataResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: ListTagsForResourceRequest
    ): ZStream[Any, AwsError, zio.aws.athena.model.Tag.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.athena.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse,
        Tag
      ](
        "listTagsForResource",
        api.listTagsForResource,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.tags().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.athena.model.Tag.wrap(item))
        .provideEnvironment(r)
    def listTagsForResourcePaginated(
        request: ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.athena.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.athena.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.athena.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.athena.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def listNamedQueries(
        request: ListNamedQueriesRequest
    ): ZStream[Any, AwsError, NamedQueryId] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest,
      ListNamedQueriesResponse,
      java.lang.String
    ](
      "listNamedQueries",
      api.listNamedQueries,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.namedQueryIds().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.athena.model.primitives.NamedQueryId(item))
      .provideEnvironment(r)
    def listNamedQueriesPaginated(
        request: ListNamedQueriesRequest
    ): IO[AwsError, zio.aws.athena.model.ListNamedQueriesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest,
        ListNamedQueriesResponse
      ]("listNamedQueries", api.listNamedQueries)(request.buildAwsValue())
        .map(zio.aws.athena.model.ListNamedQueriesResponse.wrap)
        .provideEnvironment(r)
    def deleteWorkGroup(
        request: DeleteWorkGroupRequest
    ): IO[AwsError, zio.aws.athena.model.DeleteWorkGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.DeleteWorkGroupRequest,
        DeleteWorkGroupResponse
      ]("deleteWorkGroup", api.deleteWorkGroup)(request.buildAwsValue())
        .map(zio.aws.athena.model.DeleteWorkGroupResponse.wrap)
        .provideEnvironment(r)
    def getDatabase(
        request: GetDatabaseRequest
    ): IO[AwsError, zio.aws.athena.model.GetDatabaseResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.GetDatabaseRequest,
        GetDatabaseResponse
      ]("getDatabase", api.getDatabase)(request.buildAwsValue())
        .map(zio.aws.athena.model.GetDatabaseResponse.wrap)
        .provideEnvironment(r)
    def createWorkGroup(
        request: CreateWorkGroupRequest
    ): IO[AwsError, zio.aws.athena.model.CreateWorkGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.CreateWorkGroupRequest,
        CreateWorkGroupResponse
      ]("createWorkGroup", api.createWorkGroup)(request.buildAwsValue())
        .map(zio.aws.athena.model.CreateWorkGroupResponse.wrap)
        .provideEnvironment(r)
    def getWorkGroup(
        request: GetWorkGroupRequest
    ): IO[AwsError, zio.aws.athena.model.GetWorkGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.GetWorkGroupRequest,
        GetWorkGroupResponse
      ]("getWorkGroup", api.getWorkGroup)(request.buildAwsValue())
        .map(zio.aws.athena.model.GetWorkGroupResponse.wrap)
        .provideEnvironment(r)
    def batchGetQueryExecution(request: BatchGetQueryExecutionRequest): IO[
      AwsError,
      zio.aws.athena.model.BatchGetQueryExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionRequest,
      BatchGetQueryExecutionResponse
    ]("batchGetQueryExecution", api.batchGetQueryExecution)(
      request.buildAwsValue()
    ).map(zio.aws.athena.model.BatchGetQueryExecutionResponse.wrap)
      .provideEnvironment(r)
    def startQueryExecution(
        request: StartQueryExecutionRequest
    ): IO[AwsError, zio.aws.athena.model.StartQueryExecutionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.StartQueryExecutionRequest,
        StartQueryExecutionResponse
      ]("startQueryExecution", api.startQueryExecution)(request.buildAwsValue())
        .map(zio.aws.athena.model.StartQueryExecutionResponse.wrap)
        .provideEnvironment(r)
    def getQueryResults(
        request: GetQueryResultsRequest
    ): IO[AwsError, StreamingOutputResult[
      Any,
      zio.aws.athena.model.ResultSetMetadata.ReadOnly,
      zio.aws.athena.model.Row.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.athena.model.GetQueryResultsRequest,
      GetQueryResultsResponse,
      Row
    ](
      "getQueryResults",
      api.getQueryResults,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.resultSet().rows().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(r =>
            zio.aws.athena.model.ResultSetMetadata
              .wrap(r.resultSet().resultSetMetadata())
          )
          .mapOutput(_.map(item => zio.aws.athena.model.Row.wrap(item)))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getQueryResultsPaginated(
        request: GetQueryResultsRequest
    ): IO[AwsError, zio.aws.athena.model.GetQueryResultsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.GetQueryResultsRequest,
        GetQueryResultsResponse
      ]("getQueryResults", api.getQueryResults)(request.buildAwsValue())
        .map(zio.aws.athena.model.GetQueryResultsResponse.wrap)
        .provideEnvironment(r)
    def stopQueryExecution(
        request: StopQueryExecutionRequest
    ): IO[AwsError, zio.aws.athena.model.StopQueryExecutionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.athena.model.StopQueryExecutionRequest,
        StopQueryExecutionResponse
      ]("stopQueryExecution", api.stopQueryExecution)(request.buildAwsValue())
        .map(zio.aws.athena.model.StopQueryExecutionResponse.wrap)
        .provideEnvironment(r)
  }
  def listDatabases(request: ListDatabasesRequest): ZStream[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.Database.ReadOnly
  ] = ZStream.serviceWithStream(_.listDatabases(request))
  def listDatabasesPaginated(request: ListDatabasesRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.ListDatabasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDatabasesPaginated(request))
  def updateDataCatalog(request: UpdateDataCatalogRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.UpdateDataCatalogResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDataCatalog(request))
  def updateWorkGroup(request: UpdateWorkGroupRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.UpdateWorkGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateWorkGroup(request))
  def getPreparedStatement(request: GetPreparedStatementRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.GetPreparedStatementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPreparedStatement(request))
  def listQueryExecutions(
      request: ListQueryExecutionsRequest
  ): ZStream[zio.aws.athena.Athena, AwsError, QueryExecutionId] =
    ZStream.serviceWithStream(_.listQueryExecutions(request))
  def listQueryExecutionsPaginated(request: ListQueryExecutionsRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.ListQueryExecutionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listQueryExecutionsPaginated(request))
  def listDataCatalogs(request: ListDataCatalogsRequest): ZStream[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.DataCatalogSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDataCatalogs(request))
  def listDataCatalogsPaginated(request: ListDataCatalogsRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.ListDataCatalogsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDataCatalogsPaginated(request))
  def getNamedQuery(request: GetNamedQueryRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.GetNamedQueryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getNamedQuery(request))
  def updateNamedQuery(request: UpdateNamedQueryRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.UpdateNamedQueryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateNamedQuery(request))
  def deletePreparedStatement(request: DeletePreparedStatementRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.DeletePreparedStatementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePreparedStatement(request))
  def listEngineVersions(request: ListEngineVersionsRequest): ZStream[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.EngineVersion.ReadOnly
  ] = ZStream.serviceWithStream(_.listEngineVersions(request))
  def listEngineVersionsPaginated(request: ListEngineVersionsRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.ListEngineVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEngineVersionsPaginated(request))
  def deleteNamedQuery(request: DeleteNamedQueryRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.DeleteNamedQueryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteNamedQuery(request))
  def getTableMetadata(request: GetTableMetadataRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.GetTableMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTableMetadata(request))
  def batchGetNamedQuery(request: BatchGetNamedQueryRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.BatchGetNamedQueryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetNamedQuery(request))
  def createNamedQuery(request: CreateNamedQueryRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.CreateNamedQueryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createNamedQuery(request))
  def getDataCatalog(request: GetDataCatalogRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.GetDataCatalogResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDataCatalog(request))
  def listWorkGroups(request: ListWorkGroupsRequest): ZStream[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.WorkGroupSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listWorkGroups(request))
  def listWorkGroupsPaginated(request: ListWorkGroupsRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.ListWorkGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorkGroupsPaginated(request))
  def listPreparedStatements(request: ListPreparedStatementsRequest): ZStream[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.PreparedStatementSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listPreparedStatements(request))
  def listPreparedStatementsPaginated(
      request: ListPreparedStatementsRequest
  ): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.ListPreparedStatementsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPreparedStatementsPaginated(request))
  def createPreparedStatement(request: CreatePreparedStatementRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.CreatePreparedStatementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPreparedStatement(request))
  def deleteDataCatalog(request: DeleteDataCatalogRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.DeleteDataCatalogResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDataCatalog(request))
  def getQueryExecution(
      request: GetQueryExecutionRequest
  ): ZIO[zio.aws.athena.Athena, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getQueryExecution(request))
  def updatePreparedStatement(request: UpdatePreparedStatementRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.UpdatePreparedStatementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePreparedStatement(request))
  def createDataCatalog(request: CreateDataCatalogRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.CreateDataCatalogResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataCatalog(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listTableMetadata(request: ListTableMetadataRequest): ZStream[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.TableMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listTableMetadata(request))
  def listTableMetadataPaginated(request: ListTableMetadataRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.ListTableMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTableMetadataPaginated(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZStream[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.Tag.ReadOnly
  ] = ZStream.serviceWithStream(_.listTagsForResource(request))
  def listTagsForResourcePaginated(request: ListTagsForResourceRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResourcePaginated(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listNamedQueries(
      request: ListNamedQueriesRequest
  ): ZStream[zio.aws.athena.Athena, AwsError, NamedQueryId] =
    ZStream.serviceWithStream(_.listNamedQueries(request))
  def listNamedQueriesPaginated(request: ListNamedQueriesRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.ListNamedQueriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listNamedQueriesPaginated(request))
  def deleteWorkGroup(request: DeleteWorkGroupRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.DeleteWorkGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteWorkGroup(request))
  def getDatabase(request: GetDatabaseRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.GetDatabaseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDatabase(request))
  def createWorkGroup(request: CreateWorkGroupRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.CreateWorkGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWorkGroup(request))
  def getWorkGroup(request: GetWorkGroupRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.GetWorkGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWorkGroup(request))
  def batchGetQueryExecution(request: BatchGetQueryExecutionRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.BatchGetQueryExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetQueryExecution(request))
  def startQueryExecution(request: StartQueryExecutionRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.StartQueryExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startQueryExecution(request))
  def getQueryResults(
      request: GetQueryResultsRequest
  ): ZIO[zio.aws.athena.Athena, AwsError, StreamingOutputResult[
    Any,
    zio.aws.athena.model.ResultSetMetadata.ReadOnly,
    zio.aws.athena.model.Row.ReadOnly
  ]] = ZIO.serviceWithZIO(_.getQueryResults(request))
  def getQueryResultsPaginated(request: GetQueryResultsRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.GetQueryResultsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getQueryResultsPaginated(request))
  def stopQueryExecution(request: StopQueryExecutionRequest): ZIO[
    zio.aws.athena.Athena,
    AwsError,
    zio.aws.athena.model.StopQueryExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopQueryExecution(request))
}
