package zio.aws.athena.model
import zio.aws.athena.model.primitives.{BytesScannedCutoffValue, BoxedBoolean}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class WorkGroupConfigurationUpdates(
    enforceWorkGroupConfiguration: Option[BoxedBoolean] = None,
    resultConfigurationUpdates: Option[
      zio.aws.athena.model.ResultConfigurationUpdates
    ] = None,
    publishCloudWatchMetricsEnabled: Option[BoxedBoolean] = None,
    bytesScannedCutoffPerQuery: Option[BytesScannedCutoffValue] = None,
    removeBytesScannedCutoffPerQuery: Option[BoxedBoolean] = None,
    requesterPaysEnabled: Option[BoxedBoolean] = None,
    engineVersion: Option[zio.aws.athena.model.EngineVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.WorkGroupConfigurationUpdates = {
    import WorkGroupConfigurationUpdates.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.WorkGroupConfigurationUpdates
      .builder()
      .optionallyWith(
        enforceWorkGroupConfiguration.map(value => value: java.lang.Boolean)
      )(_.enforceWorkGroupConfiguration)
      .optionallyWith(
        resultConfigurationUpdates.map(value => value.buildAwsValue())
      )(_.resultConfigurationUpdates)
      .optionallyWith(
        publishCloudWatchMetricsEnabled.map(value => value: java.lang.Boolean)
      )(_.publishCloudWatchMetricsEnabled)
      .optionallyWith(
        bytesScannedCutoffPerQuery.map(value =>
          BytesScannedCutoffValue.unwrap(value): java.lang.Long
        )
      )(_.bytesScannedCutoffPerQuery)
      .optionallyWith(
        removeBytesScannedCutoffPerQuery.map(value => value: java.lang.Boolean)
      )(_.removeBytesScannedCutoffPerQuery)
      .optionallyWith(
        requesterPaysEnabled.map(value => value: java.lang.Boolean)
      )(_.requesterPaysEnabled)
      .optionallyWith(engineVersion.map(value => value.buildAwsValue()))(
        _.engineVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.WorkGroupConfigurationUpdates.ReadOnly =
    zio.aws.athena.model.WorkGroupConfigurationUpdates.wrap(buildAwsValue())
}
object WorkGroupConfigurationUpdates {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.WorkGroupConfigurationUpdates
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.WorkGroupConfigurationUpdates =
      zio.aws.athena.model.WorkGroupConfigurationUpdates(
        enforceWorkGroupConfiguration.map(value => value),
        resultConfigurationUpdates.map(value => value.asEditable),
        publishCloudWatchMetricsEnabled.map(value => value),
        bytesScannedCutoffPerQuery.map(value => value),
        removeBytesScannedCutoffPerQuery.map(value => value),
        requesterPaysEnabled.map(value => value),
        engineVersion.map(value => value.asEditable)
      )
    def enforceWorkGroupConfiguration: Option[BoxedBoolean]
    def resultConfigurationUpdates
        : Option[zio.aws.athena.model.ResultConfigurationUpdates.ReadOnly]
    def publishCloudWatchMetricsEnabled: Option[BoxedBoolean]
    def bytesScannedCutoffPerQuery: Option[BytesScannedCutoffValue]
    def removeBytesScannedCutoffPerQuery: Option[BoxedBoolean]
    def requesterPaysEnabled: Option[BoxedBoolean]
    def engineVersion: Option[zio.aws.athena.model.EngineVersion.ReadOnly]
    def getEnforceWorkGroupConfiguration: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField(
        "enforceWorkGroupConfiguration",
        enforceWorkGroupConfiguration
      )
    def getResultConfigurationUpdates: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.ResultConfigurationUpdates.ReadOnly
    ] = AwsError.unwrapOptionField(
      "resultConfigurationUpdates",
      resultConfigurationUpdates
    )
    def getPublishCloudWatchMetricsEnabled: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField(
        "publishCloudWatchMetricsEnabled",
        publishCloudWatchMetricsEnabled
      )
    def getBytesScannedCutoffPerQuery
        : ZIO[Any, AwsError, BytesScannedCutoffValue] =
      AwsError.unwrapOptionField(
        "bytesScannedCutoffPerQuery",
        bytesScannedCutoffPerQuery
      )
    def getRemoveBytesScannedCutoffPerQuery: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField(
        "removeBytesScannedCutoffPerQuery",
        removeBytesScannedCutoffPerQuery
      )
    def getRequesterPaysEnabled: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("requesterPaysEnabled", requesterPaysEnabled)
    def getEngineVersion
        : ZIO[Any, AwsError, zio.aws.athena.model.EngineVersion.ReadOnly] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.WorkGroupConfigurationUpdates
  ) extends zio.aws.athena.model.WorkGroupConfigurationUpdates.ReadOnly {
    override val enforceWorkGroupConfiguration: Option[BoxedBoolean] = scala
      .Option(impl.enforceWorkGroupConfiguration())
      .map(value => value: BoxedBoolean)
    override val resultConfigurationUpdates
        : Option[zio.aws.athena.model.ResultConfigurationUpdates.ReadOnly] =
      scala
        .Option(impl.resultConfigurationUpdates())
        .map(value =>
          zio.aws.athena.model.ResultConfigurationUpdates.wrap(value)
        )
    override val publishCloudWatchMetricsEnabled: Option[BoxedBoolean] = scala
      .Option(impl.publishCloudWatchMetricsEnabled())
      .map(value => value: BoxedBoolean)
    override val bytesScannedCutoffPerQuery: Option[BytesScannedCutoffValue] =
      scala
        .Option(impl.bytesScannedCutoffPerQuery())
        .map(value =>
          zio.aws.athena.model.primitives.BytesScannedCutoffValue(value)
        )
    override val removeBytesScannedCutoffPerQuery: Option[BoxedBoolean] = scala
      .Option(impl.removeBytesScannedCutoffPerQuery())
      .map(value => value: BoxedBoolean)
    override val requesterPaysEnabled: Option[BoxedBoolean] = scala
      .Option(impl.requesterPaysEnabled())
      .map(value => value: BoxedBoolean)
    override val engineVersion
        : Option[zio.aws.athena.model.EngineVersion.ReadOnly] = scala
      .Option(impl.engineVersion())
      .map(value => zio.aws.athena.model.EngineVersion.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.WorkGroupConfigurationUpdates
  ): zio.aws.athena.model.WorkGroupConfigurationUpdates.ReadOnly = new Wrapper(
    impl
  )
}
