package zio.aws.athena.model
import zio.aws.athena.model.primitives.{BytesScannedCutoffValue, BoxedBoolean}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class WorkGroupConfiguration(
    resultConfiguration: Option[zio.aws.athena.model.ResultConfiguration] =
      None,
    enforceWorkGroupConfiguration: Option[BoxedBoolean] = None,
    publishCloudWatchMetricsEnabled: Option[BoxedBoolean] = None,
    bytesScannedCutoffPerQuery: Option[BytesScannedCutoffValue] = None,
    requesterPaysEnabled: Option[BoxedBoolean] = None,
    engineVersion: Option[zio.aws.athena.model.EngineVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.WorkGroupConfiguration = {
    import WorkGroupConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.WorkGroupConfiguration
      .builder()
      .optionallyWith(resultConfiguration.map(value => value.buildAwsValue()))(
        _.resultConfiguration
      )
      .optionallyWith(
        enforceWorkGroupConfiguration.map(value => value: java.lang.Boolean)
      )(_.enforceWorkGroupConfiguration)
      .optionallyWith(
        publishCloudWatchMetricsEnabled.map(value => value: java.lang.Boolean)
      )(_.publishCloudWatchMetricsEnabled)
      .optionallyWith(
        bytesScannedCutoffPerQuery.map(value =>
          BytesScannedCutoffValue.unwrap(value): java.lang.Long
        )
      )(_.bytesScannedCutoffPerQuery)
      .optionallyWith(
        requesterPaysEnabled.map(value => value: java.lang.Boolean)
      )(_.requesterPaysEnabled)
      .optionallyWith(engineVersion.map(value => value.buildAwsValue()))(
        _.engineVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.WorkGroupConfiguration.ReadOnly =
    zio.aws.athena.model.WorkGroupConfiguration.wrap(buildAwsValue())
}
object WorkGroupConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.WorkGroupConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.WorkGroupConfiguration =
      zio.aws.athena.model.WorkGroupConfiguration(
        resultConfiguration.map(value => value.asEditable),
        enforceWorkGroupConfiguration.map(value => value),
        publishCloudWatchMetricsEnabled.map(value => value),
        bytesScannedCutoffPerQuery.map(value => value),
        requesterPaysEnabled.map(value => value),
        engineVersion.map(value => value.asEditable)
      )
    def resultConfiguration
        : Option[zio.aws.athena.model.ResultConfiguration.ReadOnly]
    def enforceWorkGroupConfiguration: Option[BoxedBoolean]
    def publishCloudWatchMetricsEnabled: Option[BoxedBoolean]
    def bytesScannedCutoffPerQuery: Option[BytesScannedCutoffValue]
    def requesterPaysEnabled: Option[BoxedBoolean]
    def engineVersion: Option[zio.aws.athena.model.EngineVersion.ReadOnly]
    def getResultConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.ResultConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("resultConfiguration", resultConfiguration)
    def getEnforceWorkGroupConfiguration: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField(
        "enforceWorkGroupConfiguration",
        enforceWorkGroupConfiguration
      )
    def getPublishCloudWatchMetricsEnabled: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField(
        "publishCloudWatchMetricsEnabled",
        publishCloudWatchMetricsEnabled
      )
    def getBytesScannedCutoffPerQuery
        : ZIO[Any, AwsError, BytesScannedCutoffValue] =
      AwsError.unwrapOptionField(
        "bytesScannedCutoffPerQuery",
        bytesScannedCutoffPerQuery
      )
    def getRequesterPaysEnabled: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("requesterPaysEnabled", requesterPaysEnabled)
    def getEngineVersion
        : ZIO[Any, AwsError, zio.aws.athena.model.EngineVersion.ReadOnly] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.WorkGroupConfiguration
  ) extends zio.aws.athena.model.WorkGroupConfiguration.ReadOnly {
    override val resultConfiguration
        : Option[zio.aws.athena.model.ResultConfiguration.ReadOnly] = scala
      .Option(impl.resultConfiguration())
      .map(value => zio.aws.athena.model.ResultConfiguration.wrap(value))
    override val enforceWorkGroupConfiguration: Option[BoxedBoolean] = scala
      .Option(impl.enforceWorkGroupConfiguration())
      .map(value => value: BoxedBoolean)
    override val publishCloudWatchMetricsEnabled: Option[BoxedBoolean] = scala
      .Option(impl.publishCloudWatchMetricsEnabled())
      .map(value => value: BoxedBoolean)
    override val bytesScannedCutoffPerQuery: Option[BytesScannedCutoffValue] =
      scala
        .Option(impl.bytesScannedCutoffPerQuery())
        .map(value =>
          zio.aws.athena.model.primitives.BytesScannedCutoffValue(value)
        )
    override val requesterPaysEnabled: Option[BoxedBoolean] = scala
      .Option(impl.requesterPaysEnabled())
      .map(value => value: BoxedBoolean)
    override val engineVersion
        : Option[zio.aws.athena.model.EngineVersion.ReadOnly] = scala
      .Option(impl.engineVersion())
      .map(value => zio.aws.athena.model.EngineVersion.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.WorkGroupConfiguration
  ): zio.aws.athena.model.WorkGroupConfiguration.ReadOnly = new Wrapper(impl)
}
