package zio.aws.athena.model
import zio.aws.athena.model.primitives.{Token, NamedQueryId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListNamedQueriesResponse(
    namedQueryIds: Option[Iterable[NamedQueryId]] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListNamedQueriesResponse = {
    import ListNamedQueriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListNamedQueriesResponse
      .builder()
      .optionallyWith(
        namedQueryIds.map(value =>
          value.map { item =>
            NamedQueryId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.namedQueryIds)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListNamedQueriesResponse.ReadOnly =
    zio.aws.athena.model.ListNamedQueriesResponse.wrap(buildAwsValue())
}
object ListNamedQueriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListNamedQueriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListNamedQueriesResponse =
      zio.aws.athena.model.ListNamedQueriesResponse(
        namedQueryIds.map(value => value),
        nextToken.map(value => value)
      )
    def namedQueryIds: Option[List[NamedQueryId]]
    def nextToken: Option[Token]
    def getNamedQueryIds: ZIO[Any, AwsError, List[NamedQueryId]] =
      AwsError.unwrapOptionField("namedQueryIds", namedQueryIds)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListNamedQueriesResponse
  ) extends zio.aws.athena.model.ListNamedQueriesResponse.ReadOnly {
    override val namedQueryIds: Option[List[NamedQueryId]] = scala
      .Option(impl.namedQueryIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.athena.model.primitives.NamedQueryId(item)
        }.toList
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListNamedQueriesResponse
  ): zio.aws.athena.model.ListNamedQueriesResponse.ReadOnly = new Wrapper(impl)
}
