package zio.aws.athena.model
import zio.aws.athena.model.primitives.Token
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTableMetadataResponse(
    tableMetadataList: Option[Iterable[zio.aws.athena.model.TableMetadata]] =
      None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListTableMetadataResponse = {
    import ListTableMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListTableMetadataResponse
      .builder()
      .optionallyWith(
        tableMetadataList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tableMetadataList)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListTableMetadataResponse.ReadOnly =
    zio.aws.athena.model.ListTableMetadataResponse.wrap(buildAwsValue())
}
object ListTableMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListTableMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListTableMetadataResponse =
      zio.aws.athena.model.ListTableMetadataResponse(
        tableMetadataList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def tableMetadataList
        : Option[List[zio.aws.athena.model.TableMetadata.ReadOnly]]
    def nextToken: Option[Token]
    def getTableMetadataList: ZIO[Any, AwsError, List[
      zio.aws.athena.model.TableMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("tableMetadataList", tableMetadataList)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListTableMetadataResponse
  ) extends zio.aws.athena.model.ListTableMetadataResponse.ReadOnly {
    override val tableMetadataList
        : Option[List[zio.aws.athena.model.TableMetadata.ReadOnly]] = scala
      .Option(impl.tableMetadataList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.athena.model.TableMetadata.wrap(item)
        }.toList
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListTableMetadataResponse
  ): zio.aws.athena.model.ListTableMetadataResponse.ReadOnly = new Wrapper(impl)
}
