package zio.aws.athena.model
import zio.aws.athena.model.primitives.{
  QueryString,
  NamedQueryDescriptionString,
  NameString,
  NamedQueryId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateNamedQueryRequest(
    namedQueryId: NamedQueryId,
    name: NameString,
    description: Option[NamedQueryDescriptionString] = None,
    queryString: QueryString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.UpdateNamedQueryRequest = {
    import UpdateNamedQueryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.UpdateNamedQueryRequest
      .builder()
      .namedQueryId(NamedQueryId.unwrap(namedQueryId): java.lang.String)
      .name(NameString.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          NamedQueryDescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .queryString(QueryString.unwrap(queryString): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.UpdateNamedQueryRequest.ReadOnly =
    zio.aws.athena.model.UpdateNamedQueryRequest.wrap(buildAwsValue())
}
object UpdateNamedQueryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.UpdateNamedQueryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.UpdateNamedQueryRequest =
      zio.aws.athena.model.UpdateNamedQueryRequest(
        namedQueryId,
        name,
        description.map(value => value),
        queryString
      )
    def namedQueryId: NamedQueryId
    def name: NameString
    def description: Option[NamedQueryDescriptionString]
    def queryString: QueryString
    def getNamedQueryId: ZIO[Any, Nothing, NamedQueryId] =
      ZIO.succeed(namedQueryId)
    def getName: ZIO[Any, Nothing, NameString] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, NamedQueryDescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getQueryString: ZIO[Any, Nothing, QueryString] =
      ZIO.succeed(queryString)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.UpdateNamedQueryRequest
  ) extends zio.aws.athena.model.UpdateNamedQueryRequest.ReadOnly {
    override val namedQueryId: NamedQueryId =
      zio.aws.athena.model.primitives.NamedQueryId(impl.namedQueryId())
    override val name: NameString =
      zio.aws.athena.model.primitives.NameString(impl.name())
    override val description: Option[NamedQueryDescriptionString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.athena.model.primitives.NamedQueryDescriptionString(value)
      )
    override val queryString: QueryString =
      zio.aws.athena.model.primitives.QueryString(impl.queryString())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.UpdateNamedQueryRequest
  ): zio.aws.athena.model.UpdateNamedQueryRequest.ReadOnly = new Wrapper(impl)
}
