package zio.aws.athena.model
import zio.aws.athena.model.primitives.{
  WorkGroupName,
  QueryString,
  QueryExecutionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class QueryExecution(
    queryExecutionId: Option[QueryExecutionId] = None,
    query: Option[QueryString] = None,
    statementType: Option[zio.aws.athena.model.StatementType] = None,
    resultConfiguration: Option[zio.aws.athena.model.ResultConfiguration] =
      None,
    queryExecutionContext: Option[zio.aws.athena.model.QueryExecutionContext] =
      None,
    status: Option[zio.aws.athena.model.QueryExecutionStatus] = None,
    statistics: Option[zio.aws.athena.model.QueryExecutionStatistics] = None,
    workGroup: Option[WorkGroupName] = None,
    engineVersion: Option[zio.aws.athena.model.EngineVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.QueryExecution = {
    import QueryExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.QueryExecution
      .builder()
      .optionallyWith(
        queryExecutionId.map(value =>
          QueryExecutionId.unwrap(value): java.lang.String
        )
      )(_.queryExecutionId)
      .optionallyWith(
        query.map(value => QueryString.unwrap(value): java.lang.String)
      )(_.query)
      .optionallyWith(statementType.map(value => value.unwrap))(_.statementType)
      .optionallyWith(resultConfiguration.map(value => value.buildAwsValue()))(
        _.resultConfiguration
      )
      .optionallyWith(
        queryExecutionContext.map(value => value.buildAwsValue())
      )(_.queryExecutionContext)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(statistics.map(value => value.buildAwsValue()))(
        _.statistics
      )
      .optionallyWith(
        workGroup.map(value => WorkGroupName.unwrap(value): java.lang.String)
      )(_.workGroup)
      .optionallyWith(engineVersion.map(value => value.buildAwsValue()))(
        _.engineVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.QueryExecution.ReadOnly =
    zio.aws.athena.model.QueryExecution.wrap(buildAwsValue())
}
object QueryExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.QueryExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.QueryExecution =
      zio.aws.athena.model.QueryExecution(
        queryExecutionId.map(value => value),
        query.map(value => value),
        statementType.map(value => value),
        resultConfiguration.map(value => value.asEditable),
        queryExecutionContext.map(value => value.asEditable),
        status.map(value => value.asEditable),
        statistics.map(value => value.asEditable),
        workGroup.map(value => value),
        engineVersion.map(value => value.asEditable)
      )
    def queryExecutionId: Option[QueryExecutionId]
    def query: Option[QueryString]
    def statementType: Option[zio.aws.athena.model.StatementType]
    def resultConfiguration
        : Option[zio.aws.athena.model.ResultConfiguration.ReadOnly]
    def queryExecutionContext
        : Option[zio.aws.athena.model.QueryExecutionContext.ReadOnly]
    def status: Option[zio.aws.athena.model.QueryExecutionStatus.ReadOnly]
    def statistics
        : Option[zio.aws.athena.model.QueryExecutionStatistics.ReadOnly]
    def workGroup: Option[WorkGroupName]
    def engineVersion: Option[zio.aws.athena.model.EngineVersion.ReadOnly]
    def getQueryExecutionId: ZIO[Any, AwsError, QueryExecutionId] =
      AwsError.unwrapOptionField("queryExecutionId", queryExecutionId)
    def getQuery: ZIO[Any, AwsError, QueryString] =
      AwsError.unwrapOptionField("query", query)
    def getStatementType
        : ZIO[Any, AwsError, zio.aws.athena.model.StatementType] =
      AwsError.unwrapOptionField("statementType", statementType)
    def getResultConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.ResultConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("resultConfiguration", resultConfiguration)
    def getQueryExecutionContext: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.QueryExecutionContext.ReadOnly
    ] =
      AwsError.unwrapOptionField("queryExecutionContext", queryExecutionContext)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.QueryExecutionStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getStatistics: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.QueryExecutionStatistics.ReadOnly
    ] = AwsError.unwrapOptionField("statistics", statistics)
    def getWorkGroup: ZIO[Any, AwsError, WorkGroupName] =
      AwsError.unwrapOptionField("workGroup", workGroup)
    def getEngineVersion
        : ZIO[Any, AwsError, zio.aws.athena.model.EngineVersion.ReadOnly] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.QueryExecution
  ) extends zio.aws.athena.model.QueryExecution.ReadOnly {
    override val queryExecutionId: Option[QueryExecutionId] = scala
      .Option(impl.queryExecutionId())
      .map(value => zio.aws.athena.model.primitives.QueryExecutionId(value))
    override val query: Option[QueryString] = scala
      .Option(impl.query())
      .map(value => zio.aws.athena.model.primitives.QueryString(value))
    override val statementType: Option[zio.aws.athena.model.StatementType] =
      scala
        .Option(impl.statementType())
        .map(value => zio.aws.athena.model.StatementType.wrap(value))
    override val resultConfiguration
        : Option[zio.aws.athena.model.ResultConfiguration.ReadOnly] = scala
      .Option(impl.resultConfiguration())
      .map(value => zio.aws.athena.model.ResultConfiguration.wrap(value))
    override val queryExecutionContext
        : Option[zio.aws.athena.model.QueryExecutionContext.ReadOnly] = scala
      .Option(impl.queryExecutionContext())
      .map(value => zio.aws.athena.model.QueryExecutionContext.wrap(value))
    override val status
        : Option[zio.aws.athena.model.QueryExecutionStatus.ReadOnly] = scala
      .Option(impl.status())
      .map(value => zio.aws.athena.model.QueryExecutionStatus.wrap(value))
    override val statistics
        : Option[zio.aws.athena.model.QueryExecutionStatistics.ReadOnly] = scala
      .Option(impl.statistics())
      .map(value => zio.aws.athena.model.QueryExecutionStatistics.wrap(value))
    override val workGroup: Option[WorkGroupName] = scala
      .Option(impl.workGroup())
      .map(value => zio.aws.athena.model.primitives.WorkGroupName(value))
    override val engineVersion
        : Option[zio.aws.athena.model.EngineVersion.ReadOnly] = scala
      .Option(impl.engineVersion())
      .map(value => zio.aws.athena.model.EngineVersion.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.QueryExecution
  ): zio.aws.athena.model.QueryExecution.ReadOnly = new Wrapper(impl)
}
