package zio.aws.athena.model
import java.lang.Integer
import zio.aws.athena.model.primitives.{MaxEngineVersionsCount, Token}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListEngineVersionsRequest(
    nextToken: Option[Token] = None,
    maxResults: Option[MaxEngineVersionsCount] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListEngineVersionsRequest = {
    import ListEngineVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListEngineVersionsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxEngineVersionsCount.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListEngineVersionsRequest.ReadOnly =
    zio.aws.athena.model.ListEngineVersionsRequest.wrap(buildAwsValue())
}
object ListEngineVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListEngineVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListEngineVersionsRequest =
      zio.aws.athena.model.ListEngineVersionsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[Token]
    def maxResults: Option[MaxEngineVersionsCount]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxEngineVersionsCount] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListEngineVersionsRequest
  ) extends zio.aws.athena.model.ListEngineVersionsRequest.ReadOnly {
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
    override val maxResults: Option[MaxEngineVersionsCount] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.athena.model.primitives.MaxEngineVersionsCount(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListEngineVersionsRequest
  ): zio.aws.athena.model.ListEngineVersionsRequest.ReadOnly = new Wrapper(impl)
}
