package zio.aws.athena.model
import zio.aws.athena.model.primitives.{BoxedBoolean, WorkGroupName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteWorkGroupRequest(
    workGroup: WorkGroupName,
    recursiveDeleteOption: Option[BoxedBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.DeleteWorkGroupRequest = {
    import DeleteWorkGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.DeleteWorkGroupRequest
      .builder()
      .workGroup(WorkGroupName.unwrap(workGroup): java.lang.String)
      .optionallyWith(
        recursiveDeleteOption.map(value => value: java.lang.Boolean)
      )(_.recursiveDeleteOption)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.DeleteWorkGroupRequest.ReadOnly =
    zio.aws.athena.model.DeleteWorkGroupRequest.wrap(buildAwsValue())
}
object DeleteWorkGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.DeleteWorkGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.DeleteWorkGroupRequest =
      zio.aws.athena.model.DeleteWorkGroupRequest(
        workGroup,
        recursiveDeleteOption.map(value => value)
      )
    def workGroup: WorkGroupName
    def recursiveDeleteOption: Option[BoxedBoolean]
    def getWorkGroup: ZIO[Any, Nothing, WorkGroupName] = ZIO.succeed(workGroup)
    def getRecursiveDeleteOption: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("recursiveDeleteOption", recursiveDeleteOption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.DeleteWorkGroupRequest
  ) extends zio.aws.athena.model.DeleteWorkGroupRequest.ReadOnly {
    override val workGroup: WorkGroupName =
      zio.aws.athena.model.primitives.WorkGroupName(impl.workGroup())
    override val recursiveDeleteOption: Option[BoxedBoolean] = scala
      .Option(impl.recursiveDeleteOption())
      .map(value => value: BoxedBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.DeleteWorkGroupRequest
  ): zio.aws.athena.model.DeleteWorkGroupRequest.ReadOnly = new Wrapper(impl)
}
