package zio.aws.athena.model
import zio.aws.athena.model.primitives.{Token, QueryExecutionId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListQueryExecutionsResponse(
    queryExecutionIds: Option[Iterable[QueryExecutionId]] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListQueryExecutionsResponse = {
    import ListQueryExecutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListQueryExecutionsResponse
      .builder()
      .optionallyWith(
        queryExecutionIds.map(value =>
          value.map { item =>
            QueryExecutionId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.queryExecutionIds)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListQueryExecutionsResponse.ReadOnly =
    zio.aws.athena.model.ListQueryExecutionsResponse.wrap(buildAwsValue())
}
object ListQueryExecutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListQueryExecutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListQueryExecutionsResponse =
      zio.aws.athena.model.ListQueryExecutionsResponse(
        queryExecutionIds.map(value => value),
        nextToken.map(value => value)
      )
    def queryExecutionIds: Option[List[QueryExecutionId]]
    def nextToken: Option[Token]
    def getQueryExecutionIds: ZIO[Any, AwsError, List[QueryExecutionId]] =
      AwsError.unwrapOptionField("queryExecutionIds", queryExecutionIds)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListQueryExecutionsResponse
  ) extends zio.aws.athena.model.ListQueryExecutionsResponse.ReadOnly {
    override val queryExecutionIds: Option[List[QueryExecutionId]] = scala
      .Option(impl.queryExecutionIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.athena.model.primitives.QueryExecutionId(item)
        }.toList
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListQueryExecutionsResponse
  ): zio.aws.athena.model.ListQueryExecutionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
