package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetWorkGroupResponse(
    workGroup: Option[zio.aws.athena.model.WorkGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetWorkGroupResponse = {
    import GetWorkGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetWorkGroupResponse
      .builder()
      .optionallyWith(workGroup.map(value => value.buildAwsValue()))(
        _.workGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.GetWorkGroupResponse.ReadOnly =
    zio.aws.athena.model.GetWorkGroupResponse.wrap(buildAwsValue())
}
object GetWorkGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetWorkGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetWorkGroupResponse =
      zio.aws.athena.model
        .GetWorkGroupResponse(workGroup.map(value => value.asEditable))
    def workGroup: Option[zio.aws.athena.model.WorkGroup.ReadOnly]
    def getWorkGroup
        : ZIO[Any, AwsError, zio.aws.athena.model.WorkGroup.ReadOnly] =
      AwsError.unwrapOptionField("workGroup", workGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetWorkGroupResponse
  ) extends zio.aws.athena.model.GetWorkGroupResponse.ReadOnly {
    override val workGroup: Option[zio.aws.athena.model.WorkGroup.ReadOnly] =
      scala
        .Option(impl.workGroup())
        .map(value => zio.aws.athena.model.WorkGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetWorkGroupResponse
  ): zio.aws.athena.model.GetWorkGroupResponse.ReadOnly = new Wrapper(impl)
}
